function it2=ST1toIT2(sys, fou)

% ==============================================
%   PROGRAM AIM : 
%         TO CONVERT AND GENERATE INTERVAL TYPE-2 GFS FILE AND STRUCTURE 
%         FROM SIMPLE TYPE-1 GFS/FIS FILE OR STRUCTURE
% ==============================================
%   HOW TO RUN :
%         1. fou is Percentage FOU matrix with elements equal to No. of
%         Inputs and Outputs e.g. fou = [2 1 3]
%         2. ST1toIT2('Test ST1.GFS', fou)
% ==============================================
%   SATVIR SINGH SIDHU, ARUN KHOSLA, JASBIR SINGH SAINI 
%   MARCH 2009
%   COPYRIGHT RESERVED
% ==============================================

if isstr(sys)
    st1 = rdgfs(sys);
elseif isfis(sys)
    st1 = fis2gfs(sys);
elseif isgfs(sys)
    st1 = sys;
else
    error('Not a valid FLS format');
end

if length(fou)~=(length(st1.Input)+length(st1.Output))
    error('Invalid Percentage FOU input matrix')
end
    
it2.Name = strcat('IT2_', st1.Name);
it2.Fuzzification = 'Interval Type-2';
it2.Approach = 'Principal MF + FOU';
it2.TNorm = st1.TNorm;
it2.SNorm = st1.SNorm;
it2.ImpliMethod = st1.ImpliMethod;
it2.AggreMethod = st1.AggreMethod;
it2.TRedMethod = 'Centroid';
it2.DeFuzzMethod = st1.DeFuzzMethod;

for i = 1:length(st1.Input)
    it2.Input(1, i).Name = st1.Input(1, i).Name;
    it2.Input(1, i).UOD = st1.Input(1, i).UOD;
    
    for j = 1:length(st1.Input(1, i).mf)
        it2.Input(1, i).mf(1, j).MFName = st1.Input(1, i).mf(1, j).MFName;
        it2.Input(1, i).mf(1, j).PMFShape = st1.Input(1, i).mf(1, j).Shape;
        Para = st1.Input(1, i).mf(1, j).Params;
        it2.Input(1, i).mf(1, j).PMFParams = Para;
        it2.Input(1, i).mf(1, j).FOU = fou(i);
    end
end

for i = 1:length(st1.Output)
    it2.Output(1, i).Name = st1.Output(1, i).Name;
    it2.Output(1, i).UOD = st1.Output(1, i).UOD;
    
    for j = 1:length(st1.Output(1, i).mf)
        it2.Output(1, i).mf(1, j).MFName = st1.Output(1, i).mf(1, j).MFName;
        it2.Output(1, i).mf(1, j).PMFShape = st1.Output(1, i).mf(1, j).Shape;
        Para = st1.Output(1, i).mf(1, j).Params;
        it2.Output(1, i).mf(1, j).PMFParams = Para;
        it2.Output(1, i).mf(1, j).FOU = fou(i+length(st1.Input));
    end
end

it2.Rule = st1.Rule;

%wrgfs(it2)