%     NITOOL     NATURE INSPIRED TOOLBOX

% ======================================================
%   PROGRAM AIM :
%         ABOUT NATURE INSPIRED TOOLBOX [NIT]
% ======================================================
%   USAGE :
%         1. nitool(structure)
% ==============================================
%   SATVIR SINGH SIDHU, ARUN KHOSLA, JASBIR SINGH SAINI
%   JULY 2009
%   COPYRIGHT RESERVED
% ==============================================

function aboutNIT(nit)
figName = ['About NI Toolbox: ' nit.Name];
%===================================
% Information for all objects
frmColor=192/255*[1 1 1];
btnColor=192/255*[1 1 1];
popupColor=192/255*[1 1 1];
editColor=255/255*[1 1 1];
border=6;
spacing=6;
figPos=[425 400 400 200];

if isempty(findall(0,'Type','figure','Name',figName))
%====================================
% The FIGURE
nitAbout=figure( ...
    'Name', figName, ...
    'NumberTitle','off', ...
    'Color', [0.9 0.9 0.9], ...
    'IntegerHandle', 'off',...
    'Visible', 'on', ...
    'MenuBar', 'none', ...
    'UserData', '', ...
    'Units', 'pixels', ...
    'DefaultAxesXColor', 'black', ...
    'DefaultAxesYColor', 'black', ...
    'Position', figPos, ...
    'Resize','Off', ...
    'Tag', 'nitAbout', ...
    'DockControls', 'off');

uicontrol(nitAbout, 'Style', 'Pushbutton', 'String', 'OK', ...
    'Position', [300 20 75 20], 'Callback', 'delete(gcf)');
uicontrol(nitAbout, 'Style', 'Pushbutton', 'String', ...
    'License', 'Position', [200 20 75 20], 'Callback', 'nitgui #lic');

uicontrol(nitAbout, 'Style', 'Text', 'String', 'Nature Inspired Toolbox', ...
    'FontWeight', 'Bold', 'FontName', 'Agency FB', 'FontSize', 20,...
    'Position', [75 165 225 30], 'BackGroundColor', [0.9 0.9 0.9]);
uicontrol(nitAbout, 'Style', 'Text', 'String', 'Intelli360 Inc., INDIA',...
    'FontName', 'Verdana', 'Position', [200 140 170 15], 'FontSize', 9,...
    'BackGroundColor', [0.9 0.9 0.9]);
uicontrol(nitAbout, 'Style', 'Text', 'String', 'Copyrights Reseved',...
    'FontName', 'Verdana', 'Position', [200 125 170 15], 'FontSize', 9,...
    'BackGroundColor', [0.9 0.9 0.9]);
uicontrol(nitAbout, 'Style', 'Text', 'String', '-------------------------',...
    'FontName', 'Verdana', 'Position', [200 110 170 15], 'FontSize', 9,...
    'BackGroundColor', [0.9 0.9 0.9]);
uicontrol(nitAbout, 'Style', 'Text', 'String', 'Satvir Singh Sidhu',...
    'FontName', 'Verdana', 'Position', [200 95 170 15], 'FontSize', 9,...
    'BackGroundColor', [0.9 0.9 0.9]);
uicontrol(nitAbout, 'Style', 'Text', 'String', 'Arun Khosla',...
    'FontName', 'Verdana', 'Position', [200 80 170 15], 'FontSize', 9,...
    'BackGroundColor', [0.9 0.9 0.9]);
uicontrol(nitAbout, 'Style', 'Text', 'String', 'Jasbir Singh Saini',...
    'FontName', 'Verdana', 'Position', [200 65 170 15], 'FontSize', 9,...
    'BackGroundColor', [0.9 0.9 0.9]);
uicontrol(nitAbout, 'Style', 'Text', 'String', '-------------------------',...
    'FontName', 'Verdana', 'Position', [200 50 170 15], 'FontSize', 9,...
    'BackGroundColor', [0.9 0.9 0.9]);

axes('Parent', nitAbout, 'Position', [0.1 0.25 0.3 0.6])
sphere; axis off; colormap(hot)
uicontrol(nitAbout, 'Style', 'Text', 'String', 'Intelli360', ...
    'FontName', 'Agency FB', 'FontSize', 20,...
    'Position', [50 30 100 30], 'BackGroundColor', [0.9 0.9 0.9]);
else
    set(findall(0,'Type','figure','Name',figName), 'visible', 'on')
end