function DF = defuz(u, FS, method)

% MODIFIED DEFUZZIFICATION FUNCTION
% AS DEFUZ FROM DEFUZZ 
% FOR CONSIDERING UNAVOIDABLE CASES

% u = UOD
% FS = FUZZY SET
% method = 'centroid' / 'bisector' / etc

Area = sum(FS);
switch method
    case 'centroid'
        if Area ~= 0
            DF = sum(FS.*u)/Area;
        else
            DF = (u(1)+u(length(u)))/2;
        end
    case 'bisector'
        if Area ~= 0
            tmp = 0;
            for i=1:length(u)
                tmp = tmp + FS(i);
                if tmp >= Area/2,
                    break;
                end
            end
            DF = u(i);
        else
            DF = (u(1)+u(length(u)))/2;
        end
    case 'mom'
        if max(FS) ~= 0
            DF = mean(u(find(FS == max(FS))));
        else
            DF = (u(1)+u(length(u)))/2;
        end
    case 'som'
        if max(FS) ~= 0
            DF = min(u(find(FS == max(FS))));
        else
            DF = (u(1)+u(length(u)))/2;
        end
     case 'lom'
        if max(FS) ~= 0
            DF = max(u(find(FS == max(FS))));
        else
            DF = (u(1)+u(length(u)))/2;
        end           
end