function gfs = fis2gfs(fis);
gfs.Name = fis.name;
gfs.Fuzzification = 'Simple Type-1';
gfs.Approach = 'T1 FS';
switch fis.andMethod
    case 'prod'
        gfs.TNorm = 'Product';
    case 'min'
        gfs.TNorm = 'Minimum';
    otherwise
        Error('AND Method Mismatch');
        return;
end

switch fis.orMethod
    case 'max'
        gfs.SNorm = 'Maximum';
    case 'probor'
        gfs.SNorm = 'Probor';
    otherwise
        Error('OR Method Mismatch');
        return;
end

switch fis.impMethod
    case 'prod'
        gfs.ImpliMethod = 'Product';
    case 'min'
        gfs.ImpliMethod = 'Minimum';
    otherwise
        Error('IMPLICATION Method Mismatch');
        return;
end

switch fis.aggMethod
    case 'max'
        gfs.AggreMethod = 'Maximum';
    case 'probor'
        gfs.AggreMethod = 'Probor';
    otherwise
        Error('AGGREGATION Method Mismatch');
        return;
end

gfs.TRedMethod = 'Centroid';

switch fis.defuzzMethod
    case 'centroid'
        gfs.DeFuzzMethod = 'Centroid';
    case 'bisector'
        gfs.DeFuzzMethod = 'Bisector';
    case 'lom'
        gfs.DeFuzzMethod = 'LoM';
    case 'som'
        gfs.DeFuzzMethod = 'SoM';
    case 'mom'
        gfs.DeFuzzMethod = 'MoM';
    otherwise
        Error('DEFUZZIFICATION Method Mismatch');
        return;
end

% INPUTS
for i = 1:length(fis.input)
    gfs.Input(1, i).Name = fis.input(1, i).name;
    gfs.Input(1, i).UOD = fis.input(1, i).range;
    for j = 1:length(fis.input(1, i).mf)
        gfs.Input(1, i).mf(1, j).MFName = fis.input(1, i).mf(1, j).name;
        switch fis.input(1, i).mf(1, j).type
            case 'gaussmf'
                gfs.Input(1, i).mf(1, j).Shape = 'Gaussian';
            case 'trapmf'
                gfs.Input(1, i).mf(1, j).Shape = 'Trapezoidal';
            case 'trimf'
                gfs.Input(1, i).mf(1, j).Shape = 'Triangular';
            case 'smf'
                gfs.Input(1, i).mf(1, j).Shape = 'S-Shaped';
            case 'zmf'
                gfs.Input(1, i).mf(1, j).Shape = 'Z-Shaped';
            otherwise
                Error('Input MF Shape mismatch');
                return;
        end
        Params = num2str(fis.input(1, i).mf(1, j).params(1));
        for l = 2:length(fis.input(1, i).mf(1, j).params)
            Params = [Params ' ' num2str(fis.input(1, i).mf(1, j).params(l))];
        end
        gfs.Input(1, i).mf(1, j).Params = ['[' Params ']'];
    end
end    
% OUTPUTS
for i = 1:length(fis.output)
    gfs.Output(1, i).Name = fis.output(1, i).name;
    gfs.Output(1, i).UOD = fis.output(1, i).range;
    for j = 1:length(fis.output(1, i).mf)
        gfs.Output(1, i).mf(1, j).MFName = fis.output(1, i).mf(1, j).name;
        switch fis.output(1, i).mf(1, j).type
            case 'gaussmf'
                gfs.Output(1, i).mf(1, j).Shape = 'Gaussian';
            case 'trapmf'
                gfs.Output(1, i).mf(1, j).Shape = 'Trapezoidal';
            case 'trimf'
                gfs.Output(1, i).mf(1, j).Shape = 'Triangular';
            case 'smf'
                gfs.Output(1, i).mf(1, j).Shape = 'S-Shaped';
            case 'zmf'
                gfs.Output(1, i).mf(1, j).Shape = 'Z-Shaped';
            otherwise
                Error('Output MF Shape mismatch');
                return;
        end
        Params = num2str(fis.output(1, i).mf(1, j).params(1));
        for l = 2:length(fis.output(1, i).mf(1, j).params)
            Params = [Params ' ' num2str(fis.output(1, i).mf(1, j).params(l))];
        end
        gfs.Output(1, i).mf(1, j).Params = ['[' Params ']'];        
    end
end    
% RULES
for k = 1:length(fis.rule)
    gfs.Rule(1, k) = fis.rule(1, k);
end
% wrgfs(gfs)