function mSwarm = migrateSwarm(srtSwm, ImmCurve, MxImRate, EmiCurve, MxEmRate)

if ~exist('ImmCurve', 'var')
    ImmCurve = 'Uniform Linear';
end
if ~exist('EmiCurve', 'var')
    EmiCurve = 'Uniform Linear';
end
if ~exist('MxImRate', 'var')
    MxImRate = 1;
end
if ~exist('MxEmRate', 'var')
    MxEmRate = 1;
end

[lambda mu] = getLambdaMu(srtSwm, MxImRate, ImmCurve, MxEmRate, EmiCurve);
lambdaLower = 0; lambdaUpper = 1;

% MIGRATION LOOP
for k = 1:size(srtSwm,1)
    % Normalize the immigration rate
    lambdaScale(k) = lambdaLower+(lambdaUpper-lambdaLower)*(lambda(k)-min(lambda))/(max(lambda)-min(lambda));
    % Roulette Wheel Selection (Reversed)
    for j = 1:size(srtSwm,2)
        if rand < lambdaScale(k)
            RandomNum = rand*sum(mu);
            Select = mu(1);
            EmiIdx = 1;
            while (RandomNum > Select) & (EmiIdx < size(srtSwm,1))
                EmiIdx = EmiIdx + 1;
                Select = Select + mu(EmiIdx);
            end
            mSwarm(k,j) = srtSwm(EmiIdx, j);
        else
            mSwarm(k,j) = srtSwm(k, j);
        end
    end
end

% COMPUTE LAMDA AND MU FOR WHOLE SWARM
function [lambda, mu] = getLambdaMu(Swarm, MxImm, ImmCurve, MxEmi, EmiCurve)
for numHbt = 1:size(Swarm, 1)
    switch lower(ImmCurve)
        case 'uniform linear'
            lambda(numHbt,:) = MxImm*(1-numHbt/size(Swarm,1));
        case 'exponential'
        case 'sine(-pi/2, pi/2)'
        case 'tangent(-pi, pi)'
        case 'Step at N/2'
        otherwise
            disp('Unknown Immigration Curve');
    end
    switch lower(EmiCurve)
        case 'uniform linear'
            mu(numHbt,:) = MxEmi*numHbt/size(Swarm,1);
        case 'exponential'
        case 'sine(-pi/2, pi/2)'
        case 'tangent(-pi, pi)'
        case 'Step at N/2'
        otherwise
            disp('Unknown Immigration Curve');
    end
end
