function mtSwarm = mutateSwarm(Swarm, mutRate, MutOperator, ImmCurve, MxImRate, EmiCurve, MxEmRate)

if ~exist('mutRate', 'var')
    mutRate = 0.05;
end
if ~exist('MutOperator', 'var')
    MutOperator = 'Standard';
end
if ~exist('ImmCurve', 'var')
    ImmCurve = 'Uniform Linear';
end
if ~exist('EmiCurve', 'var')
    EmiCurve = 'Uniform Linear';
end
if ~exist('MxImRate', 'var')
    MxImRate = 1;
end
if ~exist('MxEmRate', 'var')
    MxEmRate = 1;
end

switch MutOperator
    case 'Triangular'
        for idx = 1:size(Swarm,1)
            if idx <= size(Swarm,1)/2
                mRate(idx) = idx;
            elseif idx >= size(Swarm,1)/2
                mRate(idx) = size(Swarm,1)-idx+1;
            end
            mProb = mRate/sum(mRate);
        end
        for k = 1:size(Swarm,1)
            for parnum = 1:size(Swarm,2)
                MutNot = mutRate*mProb(k);
                if MutNot > rand
                    mtSwarm(k,parnum) = min(min(Swarm))+rand*(max(max(Swarm))-min(min(Swarm))+1);
                else
                    mtSwarm(k,parnum) = Swarm(k,parnum);
                end
            end
        end
    case 'Standard'
        [Lambda Mu] = getLambdaMu(Swarm, MxImRate, ImmCurve, MxEmRate, EmiCurve);
        Prob = min([Lambda Mu],[],2);
        mProb = Prob/sum(Prob);
        for k = 1:size(Swarm,1)
            for parnum = 1:size(Swarm,2)
                MutNot = mutRate*mProb(k);
                if MutNot > rand
                    mtSwarm(k,parnum) = min(min(Swarm))+rand*(max(max(Swarm))-min(min(Swarm))+1);
                else
                    mtSwarm(k,parnum) = Swarm(k,parnum);
                end
            end
        end       
    case 'Flat'
        mtSwarm = Swarm;
        rMat = rand(size(mtSwarm));
        sml = find(rMat<mutRate);
        mtSwarm(sml) = mtSwarm(sml)+(2*rand(size(sml))-1);
    otherwise
        error('Wrong Mutation Operator Choice')
end



% COMPUTE LAMDA AND MU FOR WHOLE SWARM
function [lambda, mu] = getLambdaMu(Swarm, MxImm, ImmCurve, MxEmi, EmiCurve)
for numHbt = 1:size(Swarm, 1)
    switch lower(ImmCurve)
        case 'uniform linear'
            lambda(numHbt,:) = MxImm*(1-numHbt/size(Swarm,1));
        case 'exponential'
        case 'sine(-pi/2, pi/2)'
        case 'tangent(-pi, pi)'
        case 'Step at N/2'
        otherwise
            disp('Unknown Immigration Curve');
    end
    switch lower(EmiCurve)
        case 'uniform linear'
            mu(numHbt,:) = MxEmi*numHbt/size(Swarm,1);
        case 'exponential'
        case 'sine(-pi/2, pi/2)'
        case 'tangent(-pi, pi)'
        case 'Step at N/2'
        otherwise
            disp('Unknown Immigration Curve');
    end
end
