%     NITOOL     NATURE INSPIRED TOOLBOX

% ======================================================
%   PROGRAM AIM :
%         TO RUN FROM NITOOL.M
% ======================================================
%   USAGE :
%         1. newdlg;
% ==============================================
%   SATVIR SINGH SIDHU, ARUN KHOSLA, JASBIR SINGH SAINI
%   APRIL 2011
%   COPYRIGHT RESERVED
% ==============================================

function new = newdlg(sys)
if isstr(sys)
    if strcmp(sys, 'None')
        sys.Name = 'Untitled'; sys.Type = 'PSO';
    end
end

dlgHdl = dialog('WindowStyle','Normal',...
    'Name', 'Create New NIT',...
    'Units', 'Normalized',...
    'UserData', sys,...
    'Position', [0.25 0.4 0.2 0.2]);
X = 0.1; Y = 0.6; Hgt = 0.14; Wdt = 0.3;
namHdl = uicontrol(dlgHdl, 'Style', 'Edit',...
    'String', 'NITName',...
    'Units', 'Normalized',...
    'Tag', 'namesys',...
    'BackGroundColor', [1 1 1],...
    'Position', [X Y 0.3 Hgt]);
popStr = ['.PSO'; '.BBO'; '.ACO'; '.GA '];
popHdl = uicontrol(dlgHdl, 'Style', 'PopUp',...
    'String', popStr,...
    'Tag', 'popsys',...
    'CallBack', @popdlg,...
    'Units', 'Normalized',...
    'Position', [X+0.35 Y 0.2 Hgt]);

ok = uicontrol(dlgHdl, 'Style', 'PushButton',...
    'String', 'Ok',...
    'CallBack', @okdlg,...
    'Units', 'Normalized',...
    'Position', [0.6 0.3 Wdt 0.15]);
cls = uicontrol(dlgHdl, 'Style', 'PushButton',...
    'String', 'Cancel',...
    'CallBack', 'close gcf',...
    'Units', 'Normalized',...
    'Position', [0.6 0.1 Wdt 0.15]);
new = get(dlgHdl, 'UserData');
uiwait(dlgHdl);

    function popdlg(hObject, eventdata)
        new = get(dlgHdl, 'UserData');
        val = get(popHdl, 'Value');
        new.Type = deblank(popStr(val, 2:4));
        set(dlgHdl, 'UserData', new);
        
    end
    function okdlg(hObject, eventdata)
        data = get(dlgHdl, 'UserData');
        new.Name = get(namHdl, 'String');
        set(dlgHdl, 'UserData', new);
        delete(dlgHdl);
    end
end