%     NIT     NATURE INSPIRED TOOLBOX

% ======================================================
%   PROGRAM AIM :
%         TO GET DEFAULT SYSTEM STRUCTURE
% ======================================================
%   USAGE :
%         1. out = newnit('New', 'PSO')
%         2. out = newnit('New', 'BBO')
%         3. out = newnit
% ==============================================
%   SATVIR SINGH SIDHU, ARUN KHOSLA, JASBIR SINGH SAINI
%   JULY 2009
%   COPYRIGHT RESERVED
% ==============================================

function out = newnit(nitName, nitType)
% Default setting is PSO
if nargin == 0,
    out = newdlg('None');
elseif nargin == 1,
    out.Name = nitName; out.Type = 'PSO';
elseif nargin == 2,
    out.Name = nitName; out.Type = nitType;
end

switch out.Type
    case 'PSO'  % PSO MODULE
        out.String.File = ''; out.String.Sheet = '';
        out.String.Range = ''; out.Checks.File = '';
        out.Checks.Sheet = ''; out.Checks.Range = '';
        
        out.Swarm.Model = 'HBest'; out.Swarm.PSize = 20;
        out.Swarm.VFunction = 'NoChange'; out.Swarm.NSize = 0;
        out.Swarm.Topology = '';
        
        out.Objective.File = ''; out.Objective.Sheet = '';
        out.Objective.Range = ''; out.Objective.Function = '';
        
        out.Parameter.C1 = 2.1; out.Parameter.C2 = 2.1;
        out.Parameter.C3 = 2.1; out.Parameter.MaxVelocity = 1;
        out.Parameter.Chi = 0.729; out.Parameter.WeightOption = 'Fixed';
        out.Parameter.StartWeight = 1; out.Parameter.EndWeight = 0;
        
        out.Terminate.NoChange = 100; out.Terminate.Goal = 0;
        out.Terminate.MaxIterations = 500;
        
        out.Plot.GBest = 1; out.Plot.Average = 1; out.Plot.LBest = 0;
        
    case 'BBO'  % BBO MODULE
        out.String.File = ''; out.String.Sheet = '';
        out.String.Range = ''; out.String.VFunction = 'NoChange';
        out.Checks.File = ''; out.Checks.Sheet = ''; out.Checks.Range = '';

        out.Migration.Elite = 2; out.Migration.ImmRate = 1;
        out.Migration.ImmCurve = 'Uniform Linear'; out.Migration.EmiRate = 1;
        out.Migration.EmiCurve = 'Uniform Linear';

        out.Objective.File = ''; out.Objective.Sheet = '';
        out.Objective.Range = ''; out.Objective.Function = '';
        
        out.Parameter.Habitats = 20; out.Parameter.MigOperator = 'Standard';
        out.Parameter.Migration = 0.85; out.Parameter.MutOperator = 'Standard';
        out.Parameter.Mutation = 0.05; out.Parameter.Pool = 'Old+New';
        out.Parameter.Refusal = 'Enable'; out.Parameter.Threshold = 0.5;
        
        out.Terminate.NoChange = 100; out.Terminate.Goal = 0;
        out.Terminate.MaxIterations = 500;
        
        out.Plot.Global = 1; out.Plot.Average = 1; out.Plot.LBest = 0;
        
    case 'GA'   % GA MODULE
        'Pending Module - GA'
        
    case 'ACO'  % ACO MODULE
        'Pending Module - ACO'
        
    otherwise
        'NOT define module'
end
