%     NIT     NATURE INSPIRED TOOLBOX

% ======================================================
%   PROGRAM AIM :
%         TO GET DEFAULT SYSTEM STRUCTURE
% ======================================================
%   USAGE :
%         1. out = newnit('New', 'PSO', 20, 'GBest')
%         2. out = newnit('New', 'PSO', 20, 'LBest')
%         3. out = newnit
% ==============================================
%   SATVIR SINGH SIDHU, ARUN KHOSLA, JASBIR SINGH SAINI
%   JULY 2009
%   COPYRIGHT RESERVED
% ==============================================

function nitmenu(figNit, figName, Handles)

% Get the NIT structure
oldnit=get(figNit,'UserData');
nit=oldnit{1};

optionHndl = Handles.optionHndl;
viewHndl = Handles.viewHndl;

%{
% Edit menu, create the submenu item Undo which is common to all editors/viewers------
uimenu('Parent',   optionHndl, ...
    'Label',       'Undo', ...
    'Enable',      'off', ...
    'Tag',         'undo', ...
    'Accelerator', 'Z', ...
    'Callback',    'popundo(gcf)');

% Edit menu, show the specific editor/viewer functions as submenus------------
switch figName
case 'fuzzy'
    menu_items = localfuzzyedit(editHndl);
case 'mfedit'
    menu_items = localmfedit(editHndl, fis);
case 'ruleedit'
    menu_items = localruleedit(editHndl, figNit);
case 'anfisedit'
    menu_items = localanfisedit(editHndl, figNit);
case 'ruleview'
    menu_items = localruleview(editHndl, figNit);
case 'surfview'
    menu_items = localsurfaceview(editHndl, figNit);
end

% Edit menu, show the relevant other editors/viewers as submenus--------------
for count = 1:length(menu_items.editors)
    submenu_item = menu_items.editors{count};
    
    switch submenu_item
    case 'fuzzy'
        % Edit submenu item FIS properties
        Label_Str = 'FIS Properties...';
        Tag_Str   = 'fuzzy';
        UserData  =  1;
    case 'mfedit'
        % Edit submenu item Membership functions
        Label_Str = 'Membership Functions...';
        Tag_Str   = 'mfedit';
        UserData  =  2;
    case 'ruleedit'
        % Edit submenu item Rules
        Label_Str = 'Rules...';
        Tag_Str   = 'ruleedit';
        UserData  =  3;
    end
    hs = uimenu('Parent', editHndl, ...
        'Label',       Label_Str, ...
        'Tag',         Tag_Str, ...
        'UserData',    UserData, ...
        'Accelerator', num2str(UserData), ...
        'Callback',   'fisgui #findgui');
    if count == 1
        set(hs, 'Separator','on');
    end
    
end

% View menu, show the relevant viewers as submenus----------------------------
for count = 1:length(menu_items.views)
    submenu_item = menu_items.views{count};
    
    switch submenu_item
    case 'rules'
        % View submenu item Rules
            Label_Str = 'Rules';
            Tag_Str   = 'ruleview';
            UserData  = 4;
    case 'surfaces'
        % View submenu item Surface
            Label_Str = 'Surface';
            Tag_Str   = 'surfview';
            UserData  = 5;
    end
        hs = uimenu('Parent',viewHndl, ...
            'Label',       Label_Str, ...
            'Tag',         Tag_Str, ...
            'UserData',    UserData, ...
            'Accelerator', num2str(UserData+1), ...
            'Callback',   'fisgui #findgui');
end



%}