%     NITOOL     NATURE INSPIRED TOOLBOX

% ======================================================
%   PROGRAM AIM :
%         TO EVOLVE SYSTEMS USING NATURE INSPIRED TOOLBOX [NIT]
% ======================================================
%   USAGE :
%         1. nitool('filename.EXT')
%         2. nitool file.EXT
%         3. nitool(struct)
%         4. nitool .EXT        EXT = PSO/GA/ACO/BBO
% ==============================================
%   SATVIR SINGH SIDHU, ARUN KHOSLA, JASBIR SINGH SAINI
%   JULY 2009
%   COPYRIGHT RESERVED
% ==============================================

function nitool(action)
selectColor = [1 0.3 0.3];

if nargin < 1
    newNIT = newnit;
    action=newNIT;
    nipanel = 'None';
end


if isstr(action),
    if action(1) ~= '#'
        if action(1) ~= '.'
            nit = rdnit(action);
        else
            switch upper(action(2:4))
                case 'PSO'
                    new.Type = 'PSO'; new.Name = 'Untitled';
                    nit = newnit(new.Name, new.Type);
                case 'GA'
                    new.Type = 'GA'; new.Name = 'Untitled';
                    disp('Pending Module - GA');
                case 'ACO'
                    new.Type = 'ACO'; new.Name = 'Untitled';
                    disp('Pending Module - ACO');
                case 'BBO'
                    new.Type = 'BBO'; new.Name = 'Untitled';
                    nit = newnit(new.Name, new.Type);
                otherwise
                    error('Improper system type menstioned!')
            end
        end
        nipanel = nit.Type;
        action = '#initialize';
    end
else
    nit = action;
    if isfield(nit, 'Type')
        nipanel = nit.Type;
    end
    ['WS Structure Input: ' nit.Name];
    action = '#initialize';
end

% =======================================
if strcmp(action,'#initialize')         %   INITIALIZE
    % =====================================
    % Detect any NIT Editors out there with exactly the same name
    nitName = nit.Name; nitType = nit.Type;
    figName = ['NIT Editor: ' nitName '.' nitType];
    while findall(0, 'Type', 'Figure', 'Name', figName),
        nameLen = length(nitName);
        lastChar = nitName(nameLen);
        if abs(lastChar) > 47 & abs(lastChar) < 58,
            nitName(nameLen) = lastChar + 1;
        else
            nitName = [nitName '2'];
        end
        nit.Name = nitName;
        figName = ['NIT Editor: ' nitName '.' nitType];
    end
    
    %===================================
    % Information for all objects
    frmColor = 192/255*[1 1 1];
    BtnColor = 192/255*[1 1 1];
    popupColor = 192/255*[1 1 1];
    EdtColor = 255/255*[1 1 1];
    BkColor = [0.9 0.9 0.9];
    HBColor = [0.5 0.5 0.5];
    HTColor = [1 1 0];
    PColor = [0 0 1];
    border = 6;
    spacing = 6;
    figPos = [50 150 500 450];
    maxRight = figPos(3);
    maxTop = figPos(4);
    btnWid = 110;
    btnHt = 23;
    
    %====================================
    % The NIT FIGURE
    thisnit{1}=nit;
    figNit=figure( ...
        'Name', figName, 'NumberTitle', 'off', ...
        'Color', BkColor, 'CloseRequestFcn', 'nitgui #fileclose',...
        'IntegerHandle', 'off', 'Visible', 'on', ...
        'MenuBar', 'none', 'UserData', thisnit, ...
        'Units', 'pixels', 'DefaultAxesXColor', 'black', ...
        'DefaultAxesYColor', 'black', 'Position', figPos, ...
        'Tag', 'nitFig', 'ButtonDownFcn', '', ...
        'KeyPressFcn', '', 'DockControls', 'off');
    
    % Get Menu Bar
    nitgui #initialize      %	INITIALIZE
    
    % BUTTON: RUN
    uicontrol(figNit , 'Style', 'PushButton',...
        'Units', 'Normalized', 'Position', [0.4 0.02 0.15 0.05],...
        'Callback', 'nitgui #run', 'String', 'Run');
    % BUTTON: CLC
    uicontrol(figNit , 'Style', 'PushButton',...
        'Units', 'Normalized', 'Position', [0.6 0.02 0.15 0.05],...
        'Callback', 'clc', 'String', 'CLC');
        % BUTTON: CLOSE
        uicontrol(figNit , 'Style', 'PushButton', 'Units', 'Normalized',...
        'Position', [0.8 0.02 0.15 0.05], 'Callback', 'nitgui #fileclose',...
        'String', 'Close');
    
    % ALL PANELS
    niX = 0.01; niY = 0.09; niW = 0.98; niH = 0.9;
    PSOpanel = uipanel('Parent', figNit,...
        'Position', [niX niY niW niH], 'BorderType', 'Beveledout',...
        'Visible', 'Off', 'Tag', 'PSOpanel',...
        'BackGroundColor', BkColor);
    GApanel = uipanel('Parent', figNit,...
        'Position', [niX niY niW niH], 'BorderType', 'Beveledout',...
        'Visible', 'Off', 'BackGroundColor', BkColor);
    ACOpanel = uipanel('Parent', figNit,...
        'Position', [niX niY niW niH], 'BorderType', 'Beveledout',...
        'Visible', 'Off', 'BackGroundColor', BkColor);
    BBOpanel = uipanel('Parent', figNit,...
        'Position', [niX niY niW niH], 'BorderType', 'Beveledout',...
        'Visible', 'Off', 'BackGroundColor', BkColor);
    Blkpanel = uipanel('Parent', figNit,...
        'Position', [niX niY niW niH], 'BorderType', 'Beveledout',...
        'Visible', 'Off', 'BackGroundColor', BkColor);
    
    switch upper(nipanel)
        % ===================================
        case 'PSO'      % PSO PANEL / MODULE
            % =================================
            set(PSOpanel, 'Visible', 'On');  set(GApanel, 'Visible', 'Off');
            set(ACOpanel, 'Visible', 'Off'); set(BBOpanel, 'Visible', 'Off');
            
            uicontrol(PSOpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [0.03 0.9 0.45 0.06],...
                'String', 'PSO MODULE', 'FontName', 'Agency FB',...
                'FontWeight', 'Bold', 'ForeGroundColor', PColor,...
                'FontSize', 18, 'BackGroundColor', BkColor);

            Hed = 0.03;
            encX = 0.03;  encY = 0.66;   encW = 0.45;  encH = 0.2;
            swmX = 0.03;  swmY = 0.275;  swmW = 0.45;  swmH = 0.34;
            objX = 0.03;  objY = 0.05;   objW = 0.45;  objH = 0.175;
            
            prmX = 0.52;   prmY = 0.48;   prmW = 0.45;    prmH = 0.45;
            trmX = 0.52;   trmY = 0.24;   trmW = 0.45;    trmH = 0.16;
            pltX = 0.52;   pltY = 0.05;   pltW = 0.45;    pltH = 0.12;
            
            % PARTICLE STRING ENCODING PANEL
            % =================================
            Xt = 0.02; Wt = 0.96; Ht = 0.15;
            Xe = 0.02; Ye = 0.5; We = 0.3; Xd = 0.03; He = 0.25;

            uicontrol(PSOpanel, 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [encX encY+encH encW Hed],...
                'String', 'PARTICLE STRING ENCODING', 'HorizontalAlignment', 'Left',...
                'FontName', 'Verdana', 'FontWeight', 'Bold',...
                'ForeGroundColor', HTColor, 'BackGroundColor', HBColor);
            strpanel = uipanel('Parent', PSOpanel,...
                'Position', [encX encY encW encH], 'BorderType', 'Beveledin',...
                'BackGroundColor', BkColor);

            % Particle String File
            uicontrol(strpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 0.8 Wt Ht],...
                'HorizontalAlignment', 'Left', 'String', 'Particle String (xls file)',...
                'BackGroundColor', BkColor);
            uicontrol(strpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe+0*(Xd+We) Ye We He],...
                'Tag', 'StringFile', 'CallBack', 'nitgui #strfile',...
                'String', 'Encoding.xls', 'BackGroundColor', EdtColor);
            uicontrol(strpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe+1*(Xd+We) Ye We He],...
                'Tag', 'StringSheet', 'CallBack', 'nitgui #strsheet',...
                'String', 'Particle', 'BackGroundColor', EdtColor);
            uicontrol(strpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe+2*(Xd+We) Ye We He],...
                'Tag', 'StringRange', 'CallBack', 'nitgui #strrange',...
                'String', 'B2:D91', 'BackGroundColor', EdtColor);

            % Particle Constraint File
            uicontrol(strpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 0.33 Wt Ht],...
                'HorizontalAlignment', 'Left', 'String', 'String Constraints (xls file)',...
                'BackGroundColor', BkColor);
            Xe = 0.02; Ye = 0.05; We = 0.3; Xd = 0.03; He = 0.25;
            uicontrol(strpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe+0*(Xd+We) Ye We He],...
                'Tag', 'CheckFile', 'CallBack', 'nitgui #chkfile',...
                'String', 'Encoding.xls', 'BackGroundColor', EdtColor);
            uicontrol(strpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe+1*(Xd+We) Ye We He],...
                'Tag', 'CheckSheet', 'CallBack', 'nitgui #chksheet',...
                'String', 'Checks', 'BackGroundColor', EdtColor);
            uicontrol(strpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe+2*(Xd+We) Ye We He],...
                'Tag', 'CheckRange', 'CallBack', 'nitgui #chkrange',...
                'String', 'A2:C21', 'BackGroundColor', EdtColor);
            
            % SWARM PANEL
            % =================================
            Xt = 0.02; Wt = 0.71; H = 0.135;
            Xe = 0.63; We = 0.35; Yd = 0.05;
            
            uicontrol(PSOpanel, 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [swmX swmY+swmH swmW Hed],...
                'String', 'SWARM DESCRIPTION', 'HorizontalAlignment', 'Left',...
                'FontName', 'Verdana', 'FontWeight', 'Bold',...
                'ForeGroundColor', HTColor, 'BackGroundColor', HBColor);
            swmpanel = uipanel('Parent', PSOpanel,...
                'Position', [swmX swmY swmW swmH], 'BorderType', 'Beveledin',...
                'BackGroundColor', BkColor);
            
            % Population Size
            uicontrol(swmpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 4*H+5*Yd Wt H],...
                'String', 'Population Size', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(swmpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe 4*H+5*Yd-0.01 We H],...
                'Tag', 'PSize', 'String', '20',...
                'CallBack', 'nitgui #psize', 'BackGroundColor', EdtColor);
            
            % Swarm Validation Function
            uicontrol(swmpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 3*H+4*Yd Wt H],...
                'String', 'Validation Function', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(swmpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe 3*H+4*Yd We H],...
                'Tag', 'VFun', 'String', 'NoChange',...
                'CallBack', 'nitgui #vfun', 'BackGroundColor', EdtColor);
            
            % PSO Model
            uicontrol(swmpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 2*H+3*Yd Wt H],...
                'String', 'PSO Model', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            if strcmp(nit.Swarm.Model, 'GBest'), val = 1;
            elseif strcmp(nit.Swarm.Model, 'LBest'), val = 2;
            elseif strcmp(nit.Swarm.Model, 'HBest'), val = 3; end
            uicontrol(swmpanel , 'Style', 'PopupMenu',...
                'Units', 'Normalized', 'Position', [Xe 2*H+3*Yd We H],...
                'Tag', 'PSOModel', 'CallBack', 'nitgui #psomodel',...
                'String', ['GBest';'LBest';'HBest'], 'Value', 3,...
                'BackGroundColor', EdtColor);
            
            % Neighbourhood Size
            uicontrol(swmpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 1*H+2*Yd Wt H],...
                'String', 'Neighhood Size', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            if strcmp(nit.Swarm.NSize, '1'), val = 1;
            elseif strcmp(nit.Swarm.NSize, '2'), val = 2;
            elseif strcmp(nit.Swarm.NSize, '3'), val = 3; end
            uicontrol(swmpanel , 'Style', 'PopupMenu',...
                'Units', 'Normalized', 'Position', [Xe 1*H+2*Yd We H],...
                'Tag', 'NSize', 'CallBack', 'nitgui #nsize',...
                'String', ['1'; '2'; '3'], 'Value', 1,...
                'BackGroundColor', EdtColor);
            
            % Topology
            uicontrol(swmpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 0*H+1*Yd Wt H],...
                'String', 'Topology', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            if strcmp(nit.Swarm.Topology, 'Ring'), val = 1;
            elseif strcmp(nit.Swarm.Topology, 'Linear'), val = 2;
            elseif strcmp(nit.Swarm.Topology, 'Wheel'), val = 3; end
            uicontrol(swmpanel , 'Style', 'PopupMenu',...
                'Units', 'Normalized', 'Position', [Xe 0*H+1*Yd We H],...
                'CallBack', 'nitgui #topology', 'Tag', 'Topo',...
                'String', strvcat('Ring', 'Linear', 'Wheel'), 'Value', 1,...
                'BackGroundColor', EdtColor);
            
            % OBJECTIVE PANEL
            % =================================
            Xt = 0.02; Wt = 0.96; Ht = 0.15; He = 0.14;
            Xe = 0.02; Ye = 0.5; We = 0.3; Xd = 0.03; He = 0.25;
            
            uicontrol(PSOpanel, 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [objX objY+objH objW Hed],...
                'String', 'OBJECTIVE DESCRIPTION', 'HorizontalAlignment', 'Left',...
                'FontName', 'Verdana', 'FontWeight', 'Bold',...
                'ForeGroundColor', HTColor, 'BackGroundColor', HBColor);
            objpanel = uipanel('Parent', PSOpanel,...
                'Position', [objX objY objW objH], 'BorderType', 'Beveledin',...
                'BackGroundColor', BkColor);
            
            % Training Data File
            uicontrol(objpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 0.8 Wt Ht],...
                'HorizontalAlignment', 'Left', 'String', 'Training Data (xls file)',...
                'BackGroundColor', BkColor);
            uicontrol(objpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe+0*(Xd+We) Ye We He],...
                'Tag', 'TrgFile', 'CallBack', 'nitgui #trgfile',...
                'String', 'Training.xls', 'BackGroundColor', EdtColor);
            uicontrol(objpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe+1*(Xd+We) Ye We He],...
                'Tag', 'TrgSheet', 'CallBack', 'nitgui #trgsheet',...
                'String', 'Data', 'BackGroundColor', EdtColor);
            uicontrol(objpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe+2*(Xd+We) Ye We He],...
                'Tag', 'TrgRange', 'CallBack', 'nitgui #trgrange',...
                'String', 'A1:E501', 'BackGroundColor', EdtColor);

            % Objective Function
            uicontrol(objpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 0.15 0.6 Ht],...
                'HorizontalAlignment', 'Left', 'String', 'Objective Function',...
                'BackGroundColor', BkColor);
            uicontrol(objpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xt+0.46 0.1 0.5 He],...
                'String', 'myObject', 'CallBack', 'nitgui #FitFun',...
                'Tag', 'FitnessFn', 'BackGroundColor', EdtColor);
            
            % PARAMETER PANEL
            % =================================
            Xt = 0.02; Wt = 0.76; H = 0.106;
            Xe = 0.68; We = 0.3; Yd = 0.015;

            uicontrol(PSOpanel, 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [prmX prmY+prmH prmW Hed],...
                'String', 'STRATEGIC PARAMETERS', 'HorizontalAlignment', 'Left',...
                'FontName', 'Verdana', 'FontWeight', 'Bold',...
                'ForeGroundColor', HTColor, 'BackGroundColor', HBColor);
            parapanel = uipanel('Parent', PSOpanel,...
                'Position', [prmX prmY prmW prmH], 'BorderType', 'Beveledin',...
                'BackGroundColor', BkColor);
            
            % Cognitive Acceleration Parameter
            uicontrol(parapanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 7*H+8*Yd Wt H],...
                'String', 'Cognitive Acceleration (C1)', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(parapanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe 7*H+8*Yd We H],...
                'Tag','ParC1', 'CallBack', 'nitgui #C1',...
                'String', '0.1', 'BackGroundColor', EdtColor);

            % Social Acceleration Parameter
            uicontrol(parapanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 6*H+7*Yd Wt H],...
                'String', 'Social Acceleration (C2)', 'Tag','TxtC2',...
                'HorizontalAlignment', 'Left', 'BackGroundColor', BkColor);
            uicontrol(parapanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe 6*H+7*Yd We H],...
                'Tag','ParC2', 'CallBack', 'nitgui #C2',...
                'String', '0.2', 'BackGroundColor', EdtColor);

            % Neighborhood Acceleration Parameter
            uicontrol(parapanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 5*H+6*Yd Wt H],...
                'String', 'Neighbour Acceleration (C3)', 'Tag','TxtC3',...
                'HorizontalAlignment', 'Left', 'BackGroundColor', BkColor);
            uicontrol(parapanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe 5*H+6*Yd We H],...
                'Tag','ParC3', 'CallBack', 'nitgui #C3',...
                'String', '0.3', 'BackGroundColor', EdtColor);

            % Maximum Velocity
            uicontrol(parapanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 4*H+5*Yd Wt H],...
                'String', 'Maximum Velocity (Vel)', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(parapanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe 4*H+5*Yd We H],...
                'Tag','MxVel', 'CallBack', 'nitgui #velo',...
                'String', '0.5', 'BackGroundColor', EdtColor);

            % Constriction Factor
            uicontrol(parapanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 3*H+4*Yd Wt H],...
                'String', 'Constriction Factor (Chi)', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(parapanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe 3*H+4*Yd We H],...
                'Tag','Limt', 'CallBack', 'nitgui #chi',...
                'String', '1', 'BackGroundColor', EdtColor);

            % Weight Factor
            uicontrol(parapanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 2*H+3*Yd Wt H],...
                'String', 'Weight Variation (Wv)', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(parapanel , 'Style', 'PopupMenu',...
                'Units', 'Normalized', 'Position', [Xe 2*H+3*Yd We H],...
                'Tag','WtOpt', 'CallBack', 'nitgui #WtOption',...
                'String', ['Fixed   ';'Variable'], 'BackGroundColor', EdtColor);
            uicontrol(parapanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 1*H+2*Yd Wt H],...
                'String', 'Start Inertia Weight (Ws)', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(parapanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe 1*H+2*Yd We H],...
                'Tag','StWt', 'CallBack', 'nitgui #startwt',...
                'String', '1', 'BackGroundColor', EdtColor);
            uicontrol(parapanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 0*H+1*Yd Wt H],...
                'String', 'End Inertia Weight (We)', 'Tag','TxtNdWt',...
                'HorizontalAlignment', 'Left', 'BackGroundColor', BkColor);
            uicontrol(parapanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe 0*H+1*Yd We H],...
                'Tag','NdWt', 'CallBack', 'nitgui #endwt',...
                'String', '0', 'Enable', 'Off',...
                'BackGroundColor', EdtColor);
            
            % TERMINATION CRITERIA PANEL
            % =================================
            Xt = 0.02; Wt = 0.76; H = 0.22;
            Xe = 0.78; We = 0.2; Yd = 0.075;

            uicontrol(PSOpanel, 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [trmX trmY+trmH trmW Hed],...
                'String', 'TERMINATION CRITERIA', 'HorizontalAlignment', 'Left',...
                'FontName', 'Verdana', 'FontWeight', 'Bold',...
                'ForeGroundColor', HTColor, 'BackGroundColor', HBColor);
            trmpanel = uipanel('Parent', PSOpanel,...
                'Position', [trmX trmY trmW trmH], 'BorderType', 'Beveledin',...
                'BackGroundColor', BkColor);
            
            % Same Fitness
            uicontrol(trmpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 2*H+3*Yd Wt H],...
                'String', 'Same-Fitness Iterations', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(trmpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe 2*H+3*Yd We H],...
                'Tag', 'SameFitness', 'CallBack', 'nitgui #nochange',...
                'String', '10', 'BackGroundColor', EdtColor);

            % Objective Attained
            uicontrol(trmpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 1*H+2*Yd Wt H],...
                'String', 'Objective Value', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(trmpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe 1*H+2*Yd We H],...
                'Tag', 'ObjVal', 'CallBack', 'nitgui #objval',...
                'String', '1e-10', 'BackGroundColor', EdtColor);

            % Maximum Iterations
            uicontrol(trmpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 0*H+1*Yd Wt H],...
                'String', 'Number of Iterations', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(trmpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe 0*H+1*Yd We H],...
                'Tag', 'Iterations', 'CallBack', 'nitgui #maxitr',...
                'String', '1000', 'BackGroundColor', EdtColor);
            
            % PLOT PANEL
            % =================================
            Xt = 0.03; Wc = 0.96; H = 0.3; Yd = 0.1;

            uicontrol(PSOpanel, 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [pltX pltY+pltH pltW Hed],...
                'String', 'PLOT OPTIONS', 'HorizontalAlignment', 'Left',...
                'FontName', 'Verdana', 'FontWeight', 'Bold',...
                'ForeGroundColor', HTColor, 'BackGroundColor', HBColor);
            plotpanel = uipanel('Parent', PSOpanel,...
                'Position', [pltX pltY pltW pltH], 'BorderType', 'Beveledin',...
                'BackGroundColor', BkColor);
            
            % Global Best Plot
            uicontrol(plotpanel , 'Style', 'CheckBox',...
                'Units', 'Normalized', 'Position', [Xt 1*H+2*Yd Wc H],...
                'Tag', 'plotGBest', 'String', 'Global Best Fitness',...
                'Value', 1, 'CallBack', 'nitgui #nitplots', ...
                'BackGroundColor', BkColor);

            % Average Best Plot
            uicontrol(plotpanel , 'Style', 'CheckBox',...
                'Units', 'Normalized', 'Position', [Xt 0*H+1*Yd Wc H],...
                'Tag', 'plotAvg', 'String', 'Average Best Fitness',...
                'Value', 1, 'CallBack', 'nitgui #nitplots', ...
                'BackGroundColor', BkColor);
            
            % =================================
        case 'GA'      % GA PANEL / MODULE
            % =================================
            set(PSOpanel, 'Visible', 'Off'); set(GApanel, 'Visible', 'On');
            set(ACOpanel, 'Visible', 'Off'); set(BBOpanel, 'Visible', 'Off');
            
            uicontrol(GApanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [0.03 0.9 0.45 0.06],...
                'String', 'GA MODULE', 'FontName', 'Agency FB',...
                'FontWeight', 'Bold', 'ForeGroundColor', PColor,...
                'FontSize', 18, 'BackGroundColor', BkColor);

            Hed = 0.03;
            encX = 0.03;  encY = 0.66;   encW = 0.45;  encH = 0.2;
            swmX = 0.03;  swmY = 0.275;  swmW = 0.45;  swmH = 0.34;
            objX = 0.03;  objY = 0.05;   objW = 0.45;  objH = 0.175;
            
            prmX = 0.52;   prmY = 0.48;   prmW = 0.45;    prmH = 0.45;
            trmX = 0.52;   trmY = 0.26;   trmW = 0.45;    trmH = 0.16;
            pltX = 0.52;   pltY = 0.05;   pltW = 0.45;    pltH = 0.1;

            % CHROMOSOME STRING ENCODING PANEL
            % =================================
            uicontrol(GApanel, 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [encX encY+encH encW Hed],...
                'String', 'HABITAT STRING ENCODING', 'HorizontalAlignment', 'Left',...
                'FontName', 'Verdana', 'FontWeight', 'Bold',...
                'ForeGroundColor', HTColor, 'BackGroundColor', HBColor);            
            
            % =================================
        case 'ACO'      % ACO PANEL / MODULE
            % =================================
            set(PSOpanel, 'Visible', 'Off'); set(GApanel, 'Visible', 'Off');
            set(ACOpanel, 'Visible', 'On'); set(BBOpanel, 'Visible', 'Off');

            uicontrol(ACOpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [0.03 0.9 0.45 0.06],...
                'String', 'ACO MODULE', 'FontName', 'Agency FB',...
                'FontWeight', 'Bold', 'ForeGroundColor', PColor,...
                'FontSize', 18, 'BackGroundColor', BkColor);

            Hed = 0.03;
            encX = 0.03;  encY = 0.66;   encW = 0.45;  encH = 0.2;
            swmX = 0.03;  swmY = 0.275;  swmW = 0.45;  swmH = 0.34;
            objX = 0.03;  objY = 0.05;   objW = 0.45;  objH = 0.175;
            
            prmX = 0.52;   prmY = 0.48;   prmW = 0.45;    prmH = 0.45;
            trmX = 0.52;   trmY = 0.26;   trmW = 0.45;    trmH = 0.16;
            pltX = 0.52;   pltY = 0.05;   pltW = 0.45;    pltH = 0.1;
            
            % ANT SYSTEN STRING ENCODING PANEL
            % =================================
            uicontrol(ACOpanel, 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [encX encY+encH encW Hed],...
                'String', 'ANT STRING ENCODING', 'HorizontalAlignment', 'Left',...
                'FontName', 'Verdana', 'FontWeight', 'Bold',...
                'ForeGroundColor', HTColor, 'BackGroundColor', HBColor);

            % =================================
        case 'BBO'      % BBO PANEL / MODULE
            % =================================
            set(PSOpanel, 'Visible', 'Off'); set(GApanel, 'Visible', 'Off');
            set(ACOpanel, 'Visible', 'Off'); set(BBOpanel, 'Visible', 'On');
            
            uicontrol(BBOpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [0.03 0.9 0.45 0.06],...
                'String', 'BBO MODULE', 'FontName', 'Agency FB',...
                'FontWeight', 'Bold', 'ForeGroundColor', 'r',...
                'FontSize', 18, 'BackGroundColor', BkColor);

            Hed = 0.03;            
            encX = 0.03;  encY = 0.61;   encW = 0.45;  encH = 0.25;
            migX = 0.03;  migY = 0.28;  migW = 0.45;  migH = 0.27;
            objX = 0.03;  objY = 0.05;   objW = 0.45;  objH = 0.175;
            
            stgX = 0.52;   stgY = 0.43;   stgW = 0.45;    stgH = 0.5;
            trmX = 0.52;   trmY = 0.21;   trmW = 0.45;    trmH = 0.16;
            pltX = 0.52;   pltY = 0.05;   pltW = 0.45;    pltH = 0.1;

            %     HABITAT STRING ENCODING PANEL
            % =================================
            Xt = 0.02; Yd = 0.03; Wt = 0.96; Ht = 0.15;
            Xe = 0.02; Ye = 0.95; We = 0.3; Xd = 0.03; He = 0.18;

            uicontrol(BBOpanel, 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [encX encY+encH encW Hed],...
                'String', 'HABITAT STRING ENCODING', 'HorizontalAlignment', 'Left',...
                'FontName', 'Verdana', 'FontWeight', 'Bold',...
                'ForeGroundColor', HTColor, 'BackGroundColor', HBColor);
            strpanel = uipanel('Parent', BBOpanel,...
                'Position', [encX encY encW encH], 'BorderType', 'Beveledin',...
                'BackGroundColor', BkColor);
            
            % Habitat String File            
            uicontrol(strpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt Ht*4+Yd*7 Wt Ht],...
                'HorizontalAlignment', 'Left', 'String', 'Habitat String (xls file)',...
                'BackGroundColor', BkColor);
            uicontrol(strpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe+0*(Xd+We) Ht*3+Yd*6 We He],...
                'Tag', 'StringFileBBO', 'CallBack', 'nitgui #strfileBBO',...
                'String', '', 'BackGroundColor', EdtColor);
            uicontrol(strpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe+1*(Xd+We) Ht*3+Yd*6 We He],...
                'Tag', 'StringSheetBBO', 'CallBack', 'nitgui #strsheetBBO',...
                'String', '', 'BackGroundColor', EdtColor);
            uicontrol(strpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe+2*(Xd+We) Ht*3+Yd*6 We He],...
                'Tag', 'StringRangeBBO', 'CallBack', 'nitgui #strrangeBBO',...
                'String', '', 'BackGroundColor', EdtColor);

            % Habitat Constraint File            
            uicontrol(strpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt Ht*2+Yd*5 Wt Ht],...
                'HorizontalAlignment', 'Left', 'String', 'String Constraints (xls file)',...
                'BackGroundColor', BkColor);
            uicontrol(strpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe+0*(Xd+We) Ht*1+Yd*4 We He],...
                'Tag', 'CheckFileBBO', 'CallBack', 'nitgui #chkfileBBO',...
                'String', '', 'BackGroundColor', EdtColor);
            uicontrol(strpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe+1*(Xd+We) Ht*1+Yd*4 We He],...
                'Tag', 'CheckSheetBBO', 'CallBack', 'nitgui #chksheetBBO',...
                'String', '', 'BackGroundColor', EdtColor);
            uicontrol(strpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe+2*(Xd+We) Ht*1+Yd*4 We He],...
                'Tag', 'CheckRangeBBO', 'CallBack', 'nitgui #chkrangeBBO',...
                'String', '', 'BackGroundColor', EdtColor);
            
            % Habitat Validation Function
            uicontrol(strpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt Ht*0+Yd*2 Wt Ht],...
                'String', 'Habitat Validation Function', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(strpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe+2*We Ht*0+Yd*2 We+2*Xd He],...
                'Tag','vfunBBO', 'CallBack', 'nitgui #vfunBBO',...
                'String', '', 'BackGroundColor', EdtColor);

            % MIGRATION PANEL
            % =================================
            Xt = 0.02; Wt = 0.71; H = 0.15;
            Xe = 0.57; We = 0.41; Yd = 0.04;

            uicontrol(BBOpanel, 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [migX migY+migH migW Hed],...
                'String', 'MIGRATION CURVES', 'HorizontalAlignment', 'Left',...
                'FontName', 'Verdana', 'FontWeight', 'Bold',...
                'ForeGroundColor', HTColor, 'BackGroundColor', HBColor);
            migpanel = uipanel('Parent', BBOpanel,...
                'Position', [migX migY migW migH], 'BorderType', 'Beveledin',...
                'BackGroundColor', BkColor);
            
            % Elite Habitats
            uicontrol(migpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 4*H+5*Yd Wt H],...
                'String', 'No. Elite Habitats', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(migpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe 4*H+5*Yd We H],...
                'Tag', 'EliteBBO', 'String', '2',...
                'CallBack', 'nitgui #eliteBBO', 'BackGroundColor', EdtColor);
            
            % Maximum Immigration Rate
            uicontrol(migpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 3*H+4*Yd Wt H],...
                'String', 'Max. Immigration Rate', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(migpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe 3*H+4*Yd+0.01 We H],...
                'Tag', 'MxImmBBO', 'String', '1',...
                'CallBack', 'nitgui #ImmRateBBO', 'BackGroundColor', EdtColor);
            
            % Immigration Curve
            uicontrol(migpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 2*H+3*Yd Wt H],...
                'String', 'Immigration Curve', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            migstr = strvcat('Uniform Linear', 'Exponential',...
                'Sine(-Pi/2, Pi/2)','Tangent(-Pi, Pi)', 'Step at N/2');
            uicontrol(migpanel , 'Style', 'PopupMenu',...
                'Units', 'Normalized', 'Position', [Xe 2*H+3*Yd+0.03 We H],...
                'Tag', 'ImmCrvBBO', 'CallBack', 'nitgui #ImmBBO',...
                'String', migstr, 'Value', 1,...
                'BackGroundColor', EdtColor);
            
            % Maximum Emigration Rate
            uicontrol(migpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 1*H+2*Yd Wt H],...
                'String', 'Max. Emigration Rate', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(migpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe 1*H+2*Yd+0.01 We H],...
                'Tag', 'MxEmiBBO', 'String', '1',...
                'CallBack', 'nitgui #EmiRateBBO', 'BackGroundColor', EdtColor);
            
            % Emigration Curve
            uicontrol(migpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 0*H+1*Yd Wt H],...
                'String', 'Emigration Curve', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(migpanel , 'Style', 'PopupMenu',...
                'Units', 'Normalized', 'Position', [Xe 0*H+1*Yd+0.03 We H],...
                'Tag', 'EmiCrvBBO', 'CallBack', 'nitgui #EmiBBO',...
                'String', migstr, 'Value', 1,...
                'BackGroundColor', EdtColor);

            % OBJECTIVE PANEL
            % =================================
            Xt = 0.02; Wt = 0.96; Ht = 0.15; He = 0.14;
            Xe = 0.02; Ye = 0.5; We = 0.3; Xd = 0.03; He = 0.25;

            uicontrol(BBOpanel, 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [objX objY+objH objW Hed],...
                'String', 'OBJECTIVE DESCRIPTION', 'HorizontalAlignment', 'Left',...
                'FontName', 'Verdana', 'FontWeight', 'Bold',...
                'ForeGroundColor', HTColor, 'BackGroundColor', HBColor);
            objpanel = uipanel('Parent', BBOpanel,...
                'Position', [objX objY objW objH], 'BorderType', 'Beveledin',...
                'BackGroundColor', BkColor);
            
            % Training Data File
            uicontrol(objpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 0.8 Wt Ht],...
                'HorizontalAlignment', 'Left', 'String', 'Training Data (xls file)',...
                'BackGroundColor', BkColor);
            uicontrol(objpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe+0*(Xd+We) Ye We He],...
                'Tag', 'TrgFileBBO', 'CallBack', 'nitgui #trgfileBBO',...
                'String', '', 'BackGroundColor', EdtColor);
            uicontrol(objpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe+1*(Xd+We) Ye We He],...
                'Tag', 'TrgSheetBBO', 'CallBack', 'nitgui #trgsheetBBO',...
                'String', '', 'BackGroundColor', EdtColor);
            uicontrol(objpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe+2*(Xd+We) Ye We He],...
                'Tag', 'TrgRangeBBO', 'CallBack', 'nitgui #trgrangeBBO',...
                'String', '', 'BackGroundColor', EdtColor);
            
            % Objective Function
            uicontrol(objpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 0.15 0.6 Ht],...
                'HorizontalAlignment', 'Left', 'String', 'Objective Function',...
                'BackGroundColor', BkColor);
            uicontrol(objpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xt+0.46 0.1 0.5 He],...
                'String', '', 'CallBack', 'nitgui #FitFunBBO',...
                'Tag', 'FitnessFnBBO', 'BackGroundColor', EdtColor);

            % STRATEGY PANEL
            % =================================
            Xt = 0.02; Wt = 0.76; H = 0.09;
            Xe = 0.63; We = 0.35; Yd = 0.03;
            
            uicontrol(BBOpanel, 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [stgX stgY+stgH stgW Hed],...
                'String', 'STRATEGIC DESCRIPTION', 'HorizontalAlignment', 'Left',...
                'FontName', 'Verdana', 'FontWeight', 'Bold',...
                'ForeGroundColor', HTColor, 'BackGroundColor', HBColor);
            stgpanel = uipanel('Parent', BBOpanel,...
                'Position', [stgX stgY stgW stgH], 'BorderType', 'Beveledin',...
                'BackGroundColor', BkColor);
            
            % Number of Habitats/Island
            uicontrol(stgpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 7*H+8*Yd Wt H],...
                'String', 'No. of Habitats/Island (N)', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(stgpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe 7*H+8*Yd We H],...
                'Tag','numHbtBBO', 'CallBack', 'nitgui #Habitats',...
                'String', '20', 'BackGroundColor', EdtColor);

            % Migration Operator & Probability
            uicontrol(stgpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 6*H+7*Yd Wt H],...
                'String', 'Migration Operator', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(stgpanel , 'Style', 'PopUp',...
                'Units', 'Normalized', 'Position', [Xe 6*H+7*Yd+0.01 We H],...
                'Tag','MgOprBBO', 'CallBack', 'nitgui #migOprBBO',...
                'String', strvcat('Standard', 'Blended'),...
                'BackGroundColor', EdtColor);
            uicontrol(stgpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 5*H+6*Yd Wt H],...
                'String', 'Migr. Prob/Blend Factor', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(stgpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe 5*H+6*Yd We H],...
                'Tag','MignBBO', 'CallBack', 'nitgui #Migration',...
                'String', '0.85', 'BackGroundColor', EdtColor);

            % Mutation Operator & Probability
            uicontrol(stgpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 4*H+5*Yd Wt H],...
                'String', 'Mutation Operator', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(stgpanel , 'Style', 'PopUp',...
                'Units', 'Normalized', 'Position', [Xe 4*H+5*Yd+0.02 We H],...
                'Tag','MuOprBBO', 'CallBack', 'nitgui #mutOprBBO',...
                'String', strvcat('Standard', 'Flat', 'Triangular'), 'Value', 1, ...
                'BackGroundColor', EdtColor);
            uicontrol(stgpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 3*H+4*Yd Wt H],...
                'String', 'Mut. Prob./Scale Factor', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(stgpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe 3*H+4*Yd We H],...
                'Tag','MutBBO', 'CallBack', 'nitgui #Mutation',...
                'String', '0.005', 'BackGroundColor', EdtColor);

            % Evaluation Pool
            uicontrol(stgpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 2*H+3*Yd Wt H],...
                'String', 'Pool for Evaluations', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(stgpanel , 'Style', 'PopUp',...
                'Units', 'Normalized', 'Position', [Xe 2*H+3*Yd+0.02 We H],...
                'Tag','poolBBO', 'CallBack', 'nitgui #PoolBBO',...
                'String', strvcat('Old+New', 'New Only'), 'Value', 1,...
                'BackGroundColor', EdtColor);

            % Immigration Refusal
            uicontrol(stgpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 1*H+2*Yd Wt H],...
                'String', 'Immigration Refusal', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(stgpanel , 'Style', 'PopUp',...
                'Units', 'Normalized', 'Position', [Xe 1*H+2*Yd We H],...
                'Tag','refImmBBO', 'CallBack', 'nitgui #refuseBBO',...
                'String', strvcat('Enable','Disable'), 'Value', 1,...
                'BackGroundColor', EdtColor);
            uicontrol(stgpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 0*H+1*Yd-0.01 Wt H],...
                'String', 'Refusal Threshold', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(stgpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe 0*H+1*Yd-0.01 We H],...
                'Tag','refThBBO', 'CallBack', 'nitgui #refusThBBO',...
                'String', '0.5', 'Enable', 'On',...
                'BackGroundColor', EdtColor);
            
            % TERMINATION CRITERIA PANEL
            % =================================
            Xt = 0.02; Wt = 0.76; H = 0.25;
            Xe = 0.68; We = 0.3; Yd = 0.05;

            uicontrol(BBOpanel, 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [trmX trmY+trmH trmW Hed],...
                'String', 'TERMINATION CRITERIA', 'HorizontalAlignment', 'Left',...
                'FontName', 'Verdana', 'FontWeight', 'Bold',...
                'ForeGroundColor', HTColor, 'BackGroundColor', HBColor);
            trmpanel = uipanel('Parent', BBOpanel,...
                'Position', [trmX trmY trmW trmH], 'BorderType', 'Beveledin',...
                'BackGroundColor', BkColor);
            
            % Same Fitness
            uicontrol(trmpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 2*H+3*Yd Wt H],...
                'String', 'Same-Fitness Iterations', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(trmpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe 2*H+3*Yd We H],...
                'Tag', 'SameFitnessBBO', 'CallBack', 'nitgui #smFitBBO',...
                'String', '100', 'BackGroundColor', EdtColor);

            % Objective Attained
            uicontrol(trmpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 1*H+2*Yd Wt H],...
                'String', 'Objective Value', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(trmpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe 1*H+2*Yd We H],...
                'Tag', 'ObjValBBO', 'CallBack', 'nitgui #objvalBBO',...
                'String', '0', 'BackGroundColor', EdtColor);

            % Maximum Iterations
            uicontrol(trmpanel , 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [Xt 0*H+1*Yd Wt H],...
                'String', 'Number of Iterations', 'HorizontalAlignment', 'Left',...
                'BackGroundColor', BkColor);
            uicontrol(trmpanel , 'Style', 'Edit',...
                'Units', 'Normalized', 'Position', [Xe 0*H+1*Yd We H],...
                'Tag', 'IterationsBBO', 'CallBack', 'nitgui #maxitrBBO',...
                'String', '500', 'BackGroundColor', EdtColor);
            
            % PLOT PANEL
            % =================================
            Xt = 0.03; Wc = 0.96; H = 0.35; Yd = 0.1;

            uicontrol(BBOpanel, 'Style', 'Text',...
                'Units', 'Normalized', 'Position', [pltX pltY+pltH pltW Hed],...
                'String', 'PLOT OPTIONS', 'HorizontalAlignment', 'Left',...
                'FontName', 'Verdana', 'FontWeight', 'Bold',...
                'ForeGroundColor', HTColor, 'BackGroundColor', HBColor);
            plotpanel = uipanel('Parent', BBOpanel,...
                'Position', [pltX pltY pltW pltH], 'BorderType', 'Beveledin',...
                'BackGroundColor', BkColor);
            
            % Global Best Plot
            uicontrol(plotpanel , 'Style', 'CheckBox',...
                'Units', 'Normalized', 'Position', [Xt 1*H+2*Yd Wc H],...
                'Tag', 'plotGBestBBO', 'String', 'Global Best Fitness',...
                'Value', 1, 'CallBack', 'nitgui #GplotBBO', ...
                'BackGroundColor', BkColor);
            % Average Best Plot
            uicontrol(plotpanel , 'Style', 'CheckBox',...
                'Units', 'Normalized', 'Position', [Xt 0*H+1*Yd Wc H],...
                'Tag', 'plotAvgBBO', 'String', 'Average Best Fitness',...
                'Value', 1, 'CallBack', 'nitgui #AplotBBO', ...
                'BackGroundColor', BkColor);
            
        otherwise
            set(PSOpanel, 'Visible', 'Off'); set(GApanel, 'Visible', 'Off');
            set(ACOpanel, 'Visible', 'Off'); set(BBOpanel, 'Visible', 'Off');
    end
    
    nitool #update                  % UPDATE
    

    % =====================================
elseif strcmp(action,'#update')     % UPDATE
    % =====================================
    fig = watchon;
    oldnit = get(fig,'UserData');
    nit = oldnit{1};
    figNit = findobj(0, 'Type', 'Figure', 'Name', ['NIT Editor: ' nit.Name '.' nit.Type]);
    set(figNit, 'Name', ['NIT Editor: ' nit.Name '.' nit.Type]);
    
    switch upper(nit.Type)
            % =================================
        case 'PSO'      % PSO PANEL #UPDATE
            % =================================
            Hdl = findobj(figNit, 'Tag', 'StringFile'); set(Hdl, 'String', nit.String.File);
            Hdl = findobj(figNit, 'Tag', 'StringSheet'); set(Hdl, 'String', nit.String.Sheet);
            Hdl = findobj(figNit, 'Tag', 'StringRange'); set(Hdl, 'String', nit.String.Range);
            Hdl = findobj(figNit, 'Tag', 'CheckFile'); set(Hdl, 'String', nit.Checks.File);
            Hdl = findobj(figNit, 'Tag', 'CheckSheet'); set(Hdl, 'String', nit.Checks.Sheet);
            Hdl = findobj(figNit, 'Tag', 'CheckRange'); set(Hdl, 'String', nit.Checks.Range);
            Hdl = findobj(figNit, 'Tag', 'PSize'); set(Hdl, 'String', nit.Swarm.PSize);
            Hdl = findobj(figNit, 'Tag', 'VFun'); set(Hdl, 'String', nit.Swarm.VFunction);
            if nit.Swarm.Model=='GBest'
                Hdl = findobj(figNit, 'Tag', 'PSOModel'); set(Hdl, 'Value', 1);
                Hdl = findobj(figNit, 'Tag', 'NSize'); set(Hdl, 'Enable', 'Off');
                Hdl = findobj(figNit, 'Tag', 'Topo'); set(Hdl, 'Enable', 'Off');
                Hdl = findobj(figNit, 'Tag', 'TxtC3'); set(Hdl, 'Enable', 'Off');
                Hdl = findobj(figNit, 'Tag', 'ParC3'); set(Hdl, 'Enable', 'Off');
                LHdl = findobj(figNit, 'Tag', 'plotLBest'); set(LHdl, 'Value', nit.Plot.LBest, 'Enable', 'Off');
            elseif nit.Swarm.Model=='LBest'
                Hdl = findobj(figNit, 'Tag', 'PSOModel'); set(Hdl, 'Value', 2);
                Hdl = findobj(figNit, 'Tag', 'NSize'); set(Hdl, 'Value', nit.Swarm.NSize, 'Enable', 'On');
                Hdl = findobj(figNit, 'Tag', 'Topo'); TopStr = get(Hdl, 'String');
                Val = strmatch(strtok(nit.Swarm.Topology), TopStr, 'Exac'); set(Hdl, 'Value', Val, 'Enable', 'On');
                Hdl = findobj(figNit, 'Tag', 'TxtC2'); set(Hdl, 'Enable', 'Off');
                Hdl = findobj(figNit, 'Tag', 'ParC2'); set(Hdl, 'Enable', 'Off');
                LHdl = findobj(figNit, 'Tag', 'plotLBest'); set(LHdl, 'Value', nit.Plot.LBest, 'Enable', 'On');
            elseif nit.Swarm.Model=='HBest'
                Hdl = findobj(figNit, 'Tag', 'PSOModel'); set(Hdl, 'Value', 3);
                Hdl = findobj(figNit, 'Tag', 'NSize'); set(Hdl, 'Value', nit.Swarm.NSize, 'Enable', 'On');
                Hdl = findobj(figNit, 'Tag', 'Topo'); TopStr = get(Hdl, 'String');
                Val = strmatch(strtok(nit.Swarm.Topology), TopStr, 'exact'); set(Hdl, 'Value', Val, 'Enable', 'On');
                Hdl = findobj(figNit, 'Tag', 'TxtC3'); set(Hdl, 'Enable', 'On');
                Hdl = findobj(figNit, 'Tag', 'ParC3'); set(Hdl, 'Enable', 'On');
            end
            Hdl = findobj(figNit, 'Tag', 'TrgFile'); set(Hdl, 'String', nit.Objective.File);
            Hdl = findobj(figNit, 'Tag', 'TrgSheet'); set(Hdl, 'String', nit.Objective.Sheet);
            Hdl = findobj(figNit, 'Tag', 'TrgRange'); set(Hdl, 'String', nit.Objective.Range);
            Hdl = findobj(figNit, 'Tag', 'FitnessFn'); set(Hdl, 'String', nit.Objective.Function);
            Hdl = findobj(figNit, 'Tag', 'ParC1'); set(Hdl, 'String', nit.Parameter.C1);
            Hdl = findobj(figNit, 'Tag', 'ParC2'); set(Hdl, 'String', nit.Parameter.C2);
            Hdl = findobj(figNit, 'Tag', 'ParC3'); set(Hdl, 'String', nit.Parameter.C3);
            Hdl = findobj(figNit, 'Tag', 'MxVel'); set(Hdl, 'String', nit.Parameter.MaxVelocity);
            Hdl = findobj(figNit, 'Tag', 'Limt'); set(Hdl, 'String', nit.Parameter.Chi);
            Hdl = findobj(figNit, 'Tag', 'StWt'); set(Hdl, 'String', nit.Parameter.StartWeight);
            if strcmp(nit.Parameter.WeightOption, 'Fixed')
                Hdl = findobj(figNit, 'Tag', 'WtOpt'); set(Hdl, 'Value', 1);
                Hdl = findobj(figNit, 'Tag', 'TxtNdWt'); set(Hdl, 'Enable', 'Off');
                Hdl = findobj(figNit, 'Tag', 'NdWt'); set(Hdl, 'Enable', 'Off');
            elseif strcmp(nit.Parameter.WeightOption, 'Variable')
                Hdl = findobj(figNit, 'Tag', 'WtOpt'); set(Hdl, 'Value', 2);
                Hdl = findobj(figNit, 'Tag', 'TxtNdWt'); set(Hdl, 'Enable', 'On');
                Hdl = findobj(figNit, 'Tag', 'NdWt'); set(Hdl, 'String', nit.Parameter.EndWeight, 'Enable', 'On');
            end
            Hdl = findobj(figNit, 'Tag', 'SameFitness'); set(Hdl, 'String', nit.Terminate.NoChange);
            Hdl = findobj(figNit, 'Tag', 'ObjVal'); set(Hdl, 'String', nit.Terminate.Goal);
            Hdl = findobj(figNit, 'Tag', 'Iterations'); set(Hdl, 'String', nit.Terminate.MaxIterations);
            GHdl = findobj(figNit, 'Tag', 'plotGBest'); set(GHdl, 'Value', nit.Plot.Global);
            PHdl = findobj(figNit, 'Tag', 'plotAvg'); set(PHdl, 'Value', nit.Plot.Average);
            Val = [nit.Plot.Global nit.Plot.Average];
            figPlot = findobj(0, 'Type', 'Figure', 'Name', 'NIT Plots', 'Tag', 'nitPlot');
            if sum(Val) ~= 0, set(figPlot, 'Visible', 'On');
            else, set(figPlot, 'Visible', 'Off'); end
        
            % =================================
        case 'GA'      % GA PANEL #UPDATE
            % =================================
            'Pending - GA'
        
            % =================================
        case 'ACO'      % ACO PANEL #UPDATE
            % =================================
            'Pending - ACO'
        
            % =================================
        case 'BBO'      % BBO PANEL #UPDATE
            % =================================
            Hdl = findobj(figNit, 'Tag', 'StringFileBBO'); set(Hdl, 'String', nit.String.File);
            Hdl = findobj(figNit, 'Tag', 'StringSheetBBO'); set(Hdl, 'String', nit.String.Sheet);
            Hdl = findobj(figNit, 'Tag', 'StringRangeBBO'); set(Hdl, 'String', nit.String.Range);
            Hdl = findobj(figNit, 'Tag', 'CheckFileBBO'); set(Hdl, 'String', nit.Checks.File);
            Hdl = findobj(figNit, 'Tag', 'CheckSheetBBO'); set(Hdl, 'String', nit.Checks.Sheet);
            Hdl = findobj(figNit, 'Tag', 'CheckRangeBBO'); set(Hdl, 'String', nit.Checks.Range);
            Hdl = findobj(figNit, 'Tag', 'vfunBBO'); set(Hdl, 'String', nit.String.VFunction);
            
            Hdl = findobj(figNit, 'Tag', 'EliteBBO'); set(Hdl, 'String', nit.Migration.Elite);
            Hdl = findobj(figNit, 'Tag', 'MxImmBBO'); set(Hdl, 'String', nit.Migration.ImmRate);
            if strcmp(deblank(nit.Migration.ImmCurve), 'Uniform Linear')
                Hdl = findobj(figNit, 'Tag', 'ImmCrvBBO'); set(Hdl, 'Value', 1);
            elseif strcmp(deblank(nit.Migration.ImmCurve), 'Exponential')
                Hdl = findobj(figNit, 'Tag', 'ImmCrvBBO'); set(Hdl, 'Value', 2);
            elseif strcmp(deblank(nit.Migration.ImmCurve), 'Sine(-Pi/2, Pi/2)'),
                Hdl = findobj(figNit, 'Tag', 'ImmCrvBBO'); set(Hdl, 'Value', 3);
            elseif strcmp(deblank(nit.Migration.ImmCurve), 'Tangent(-Pi, Pi)')
                Hdl = findobj(figNit, 'Tag', 'ImmCrvBBO'); set(Hdl, 'Value', 4);
            elseif strcmp(deblank(nit.Migration.ImmCurve), 'Step at N/2')
                Hdl = findobj(figNit, 'Tag', 'ImmCrvBBO'); set(Hdl, 'Value', 5);
            end
            Hdl = findobj(figNit, 'Tag', 'MxEmiBBO'); set(Hdl, 'String', nit.Migration.EmiRate);
            if strcmp(deblank(nit.Migration.EmiCurve), 'Uniform Linear')
                Hdl = findobj(figNit, 'Tag', 'EmiCrvBBO'); set(Hdl, 'Value', 1);
            elseif strcmp(deblank(nit.Migration.EmiCurve), 'Exponential')
                Hdl = findobj(figNit, 'Tag', 'EmiCrvBBO'); set(Hdl, 'Value', 2);
            elseif strcmp(deblank(nit.Migration.EmiCurve), 'Sine(-Pi/2, Pi/2)')
                Hdl = findobj(figNit, 'Tag', 'EmiCrvBBO'); set(Hdl, 'Value', 3);
            elseif strcmp(deblank(nit.Migration.EmiCurve), 'Tangent(-Pi, Pi)')
                Hdl = findobj(figNit, 'Tag', 'EmiCrvBBO'); set(Hdl, 'Value', 4);
            elseif strcmp(deblank(nit.Migration.EmiCurve), 'Step at N/2')
                Hdl = findobj(figNit, 'Tag', 'EmiCrvBBO'); set(Hdl, 'Value', 5);
            end
            
            Hdl = findobj(figNit, 'Tag', 'TrgFileBBO'); set(Hdl, 'String', nit.Objective.File);
            Hdl = findobj(figNit, 'Tag', 'TrgSheetBBO'); set(Hdl, 'String', nit.Objective.Sheet);
            Hdl = findobj(figNit, 'Tag', 'TrgRangeBBO'); set(Hdl, 'String', nit.Objective.Range);
            Hdl = findobj(figNit, 'Tag', 'FitnessFnBBO'); set(Hdl, 'String', nit.Objective.Function);

            Hdl = findobj(figNit, 'Tag', 'numHbtBBO'); set(Hdl, 'String', nit.Parameter.Habitats);
            if strcmp(nit.Parameter.MigOperator, 'Standard')
                Hdl = findobj(figNit, 'Tag', 'MgOprBBO'); set(Hdl, 'Value', 1);
            elseif strcmp(nit.Parameter.MigOperator, 'Blended')
                Hdl = findobj(figNit, 'Tag', 'MgOprBBO'); set(Hdl, 'Value', 2);
            end
            Hdl = findobj(figNit, 'Tag', 'MignBBO'); set(Hdl, 'String', nit.Parameter.Migration);
            if strcmp(nit.Parameter.MutOperator, 'Standard')
                Hdl = findobj(figNit, 'Tag', 'MuOprBBO'); set(Hdl, 'Value', 1);
            elseif strcmp(nit.Parameter.MutOperator, 'Flat')
                Hdl = findobj(figNit, 'Tag', 'MuOprBBO'); set(Hdl, 'Value', 2);
            elseif strcmp(nit.Parameter.MutOperator, 'Triangular')
                Hdl = findobj(figNit, 'Tag', 'MuOprBBO'); set(Hdl, 'Value', 3);
            end
            Hdl = findobj(figNit, 'Tag', 'MutBBO'); set(Hdl, 'String', nit.Parameter.Mutation);
            if strcmp(nit.Parameter.Pool, 'Old+New')
                Hdl = findobj(figNit, 'Tag', 'poolBBO'); set(Hdl, 'Value', 1);
            elseif strcmp(nit.Parameter.Pool, 'New Only')
                Hdl = findobj(figNit, 'Tag', 'poolBBO'); set(Hdl, 'Value', 2);
            end
            if strcmp(nit.Parameter.Refusal, 'Enable')
                Hdl = findobj(figNit, 'Tag', 'refImmBBO'); set(Hdl, 'Value', 1);
                ObjEdt = findobj(figNit, 'Style', 'Edit', 'Tag', 'refThBBO'); set(ObjEdt, 'Enable', 'On');
            elseif strcmp(nit.Parameter.Refusal, 'Disable')
                Hdl = findobj(figNit, 'Tag', 'refImmBBO'); set(Hdl, 'Value', 2);
                ObjEdt = findobj(figNit, 'Style', 'Edit', 'Tag', 'refThBBO'); set(ObjEdt, 'Enable', 'Off');
            end
            Hdl = findobj(figNit, 'Tag', 'refThBBO'); set(Hdl, 'String', nit.Parameter.Threshold);
            
            Hdl = findobj(figNit, 'Tag', 'SameFitnessBBO'); set(Hdl, 'String', nit.Terminate.NoChange);
            Hdl = findobj(figNit, 'Tag', 'ObjValBBO'); set(Hdl, 'String', nit.Terminate.Goal);
            Hdl = findobj(figNit, 'Tag', 'IterationsBBO'); set(Hdl, 'String', nit.Terminate.MaxIterations);

            Hdl = findobj(figNit, 'Tag', 'plotGBestBBO'); set(Hdl, 'Value', nit.Plot.Global);
            Hdl = findobj(figNit, 'Tag', 'plotAvgBBO'); set(Hdl, 'Value', nit.Plot.Average);
            
        otherwise
            'Improper File Extension'
    end
    set(figNit, 'UserData', nit, 'Visible', 'On');
    watchoff(figNit);
end
