%     NITOOL     NATURE INSPIRED TOOLBOX

% ======================================================
%   PROGRAM AIM :
%         TO RUN FOR EVOLUTION
% ======================================================
%   USAGE :
%         1. runnit(nit, iSwarm)
% ==============================================
%   SATVIR SINGH SIDHU, ARUN KHOSLA, JASBIR SINGH SAINI
%   JULY 2009
%   COPYRIGHT RESERVED
% ==============================================

function runnit(argu)
RESULT = []; LBest = [];
STime = clock;
if isstr(argu)
    if argu(1)~='#'
        nit = rdnit(argu);
        argu = '#launch';
    end
else
    nit = argu;
    argu = '#launch';
end

if strcmp(argu, '#launch')
    % LOOK FOR PLOT FIGURE IF AVAILABLE
    % =========================
    figPlot = findobj(0, 'Type', 'Figure', 'Name', ['NIT Plots: ' nit.Name '.' nit.Type]);
    thisnit{1} = nit;
    
    if ~isempty(figPlot)
        delete(figPlot);
    end
    BkColor = [0.9 0.9 0.9];
    figPlot = figure('Name', ['NIT Plots: ' nit.Name '.' nit.Type], ...
        'NumberTitle', 'off', 'Color', BkColor, ...
        'CloseRequestFcn', 'delete(gcf)', 'IntegerHandle', 'off',...
        'Visible', 'on', 'MenuBar', 'figure', ...
        'UserData', thisnit, 'Units', 'pixels', ...
        'DefaultAxesXColor', 'black', 'DefaultAxesYColor', 'black', ...
        'Position', [560 150 500 450], 'Tag', 'nitPlot', ...
        'ButtonDownFcn', '', 'KeyPressFcn', '', ...
        'DockControls', 'off');
    
    plX = 0.01; plY = 0.19; plW = 0.98; plH = 0.8;
    % Plot Panel
    Plotpanel = uipanel('Parent', figPlot,...
        'Position', [plX plY plW plH], 'BorderType', 'Beveledout',...
        'Visible', 'On', 'Tag', 'PlotPanel',...
        'BackGroundColor', BkColor);
    % Plot Area
    xPlot = axes('Parent', Plotpanel,...
        'Units', 'pixels', 'FontSize', 8,...
        'FontName', 'Verdana', 'Position', [50 50 425 275],...
        'Tag', 'NIGraph', 'Box', 'On',...
        'XLim', [0 100], 'YLim', [0 10],...
        'XGrid', 'On', 'YGrid', 'On');
    UCx = 0.03; UCy = 0.08; UCw = 0.2; UCh = 0.04;
    dx = 0.27; dy = 0.04; UCyL = 0.03;
    % TIME
    uicontrol('Units', 'Normalized',...
        'Style', 'Text', 'FontName', 'Verdana',...
        'BackgroundColor', BkColor, 'Position',  [UCx UCy+dy UCw UCh],...
        'String', 'TIME');
    TimE = uicontrol('Units', 'Normalized',...
        'Style', 'Edit', 'FontName', 'Verdana',...
        'Position', [UCx UCy UCw UCh], 'Enable', 'Off',...
        'Tag', 'TimE', 'String', '',...
        'Visible', 'On');
    TimR = uicontrol('Units', 'Normalized',...
        'Style', 'Edit', 'FontName', 'Verdana',...
        'Position', [UCx UCyL UCw UCh], 'Enable', 'Off',...
        'Tag', 'TimR', 'String', '',...
        'Visible', 'On');
    % ITERATIONS
    uicontrol('Units', 'Normalized',...
        'Style', 'Text', 'BackgroundColor', BkColor,...
        'FontName', 'Verdana', 'Position',  [UCx+dx UCy+dy UCw UCh],...
        'String', 'ITERATIONS');
    ItrN = uicontrol('Units', 'Normalized',...
        'Style', 'Edit', 'FontName', 'Verdana',...
        'Position', [UCx+dx UCy UCw UCh], 'Enable', 'Off',...
        'Tag', 'ItrN', 'String', '',...
        'Visible', 'On');
    ItrR = uicontrol('Units', 'Normalized',...
        'Style', 'Edit', 'FontName', 'Verdana',...
        'Position', [UCx+dx UCyL UCw UCh], 'Enable', 'Off',...
        'Tag', 'ItrR', 'String', '',...
        'Visible', 'On');
    % FITNESSES
    uicontrol('Units', 'Normalized',...
        'Style', 'Text', 'BackgroundColor', BkColor,...
        'FontName', 'Verdana', 'Position',  [UCx+2*dx UCy+dy UCw UCh],...
        'String', 'FITNESS');
    GBstF = uicontrol('Units', 'Normalized',...
        'Style', 'Edit', 'FontName', 'Verdana',...
        'Position', [UCx+2*dx UCy UCw UCh], 'Enable', 'Off',...
        'Tag', 'GBstF', 'String', '',...
        'Visible', 'On');
    AvF = uicontrol('Units', 'Normalized',...
        'Style', 'Edit', 'FontName', 'Verdana',...
        'Position', [UCx+2*dx UCyL UCw UCh], 'Enable', 'Off',...
        'Tag', 'AvF', 'String', '',...
        'Visible', 'On');
    % Restart Button
    RestartB = uicontrol(figPlot,...
        'Style', 'PushButton', 'Units', 'Normalized',...
        'Position', [UCx+2.9*dx UCy+1.2*dy UCw-0.05 UCh],...
        'Callback', 'runnit #restart', 'UserData', '', ...
        'FontName', 'Verdana', 'Enable', 'Off',...
        'Tag', 'RestartB', 'String', 'Restart');
    % Resume Button
    ResumeB = uicontrol(figPlot,...
        'Style', 'PushButton', 'Units', 'Normalized',...
        'Position', [UCx+2.9*dx UCy UCw-0.05 UCh],...
        'Callback', 'runnit #resume', 'UserData', '', ...
        'FontName', 'Verdana', 'Enable', 'Off',...
        'Tag', 'ResumeB', 'String', 'Resume');
    % Stop Button
    StopB = uicontrol(figPlot,...
        'Style', 'PushButton', 'Units', 'Normalized',...
        'Position', [UCx+2.9*dx UCy-1.4*dy UCw-0.05 UCh],...
        'Callback', 'delete(gcf)', 'FontName', 'Verdana',...
        'Enable', 'On', 'Tag', 'StopB', 'String', 'Close');
    
    oldmat = [strtok(deblank(nit.Name),'.') '.mat'];
    if exist(oldmat, 'file') == 0          % NO - File
        argu = '#evolve';
        set(ResumeB, 'Enable', 'Off');
        set(RestartB, 'Enable', 'On');
        set(StopB, 'Enable', 'On');
    elseif exist(oldmat, 'file') == 2   % YES - File
        load(oldmat);
        if success == 1
            set(RestartB, 'Enable', 'On');
            set(ResumeB, 'Enable', 'Off');
        elseif success == 0
            set(RestartB, 'Enable', 'On');
            set(ResumeB, 'Enable', 'On');
        end
    end
    % runnit #evolve
elseif strcmp(argu, '#evolve')
    figNum = watchon;
    oldnit = get(figNum, 'UserData');
    nit = oldnit{1};
    ItrN = findobj(figNum, 'Type', 'uicontrol', 'Tag', 'ItrN');
    ItrR = findobj(figNum, 'Type', 'uicontrol', 'Tag', 'ItrR');
    TimE = findobj(figNum, 'Type', 'uicontrol', 'Tag', 'TimE');
    TimR = findobj(figNum, 'Type', 'uicontrol', 'Tag', 'TimR');
    GBstF = findobj(figNum, 'Type', 'uicontrol', 'Tag', 'GBstF');
    AvF = findobj(figNum, 'Type', 'uicontrol', 'Tag', 'AvF');
    xPlot = findobj(figNum, 'Type', 'axes', 'Tag', 'NIGraph');
    
    RestartB = findobj(figNum, 'Type', 'uicontrol', 'Tag', 'RestartB');
    udRs = get(RestartB, 'UserData');
    ResumeB = findobj(figNum, 'Type', 'uicontrol', 'Tag', 'ResumeB');
    udRe = get(ResumeB, 'UserData');
    watchoff;
    
    % PARTICLE SWARM OPTIMIZATION
    % ======================
    if strcmp(nit.Type, 'PSO')
        matfile = strtok(deblank(nit.Name),'.');
        
        % Particle Validation
        Str = xlsread(nit.String.File, nit.String.Sheet, nit.String.Range);
        Chk = xlsread(nit.Checks.File, nit.Checks.Sheet, nit.Checks.Range);
        
        % Swarm
        PSize = nit.Swarm.PSize;
        validate = nit.Swarm.VFunction;
        psoModel = nit.Swarm.Model;
        NSize = nit.Swarm.NSize;
        Topology = nit.Swarm.Topology;
        
        % Objective Function
        ObjFun = nit.Objective.Function;
        
        % PSO Parameters
        C1 = nit.Parameter.C1;                                  % C1
        C2 = nit.Parameter.C2;                                  % C2
        C3 = nit.Parameter.C3;                                  % C3
        MaxVel = nit.Parameter.MaxVelocity;          % Maximum Velocity Check
        Chi = nit.Parameter.Chi;                                % Constriction Factor Chi
        WtOpt = nit.Parameter.WeightOption;       % Weight Option: 'Fixed' or 'Variable'
        StartWt = nit.Parameter.StartWeight;             % Starting Weight Value
        EndWt = nit.Parameter.EndWeight;               % End Weight Value
        
        TrgData = xlsread(nit.Objective.File, nit.Objective.Sheet, nit.Objective.Range);
        
        % PSO Run Termination Criteria
        NoChange = nit.Terminate.NoChange;       % No Change Fitness Iterations
        Goal = nit.Terminate.Goal;              % Minimum Acceptable Error
        MaxItr = nit.Terminate.MaxIterations;       % Maximum Number of iteration to be run
        
        % INITIAL PARAMETERS
        % ==============
        if strcmp(udRs, 'restart')
            iSwarm = genrandpop(PSize, Str, Chk);
            iSwarm = feval(validate, iSwarm, Str, Chk);
            ItrNo = 1; success = 0; NCItr = 1;
            Swarm = iSwarm;
            PBest = Swarm;
            %TrgData, PBest
            PBestFit = feval(ObjFun, PBest, TrgData);
            AvgFit(ItrNo) = mean(PBestFit);
            [GBFitVal, GBNo] = min(PBestFit);
            GBestFit(ItrNo) = GBFitVal;
            GBest = PBest(GBNo, :);
            cla(xPlot);
        end
        if strcmp(udRe, 'resume')
            load(matfile); STime = clock-TimeElapsed;
            success = 0; NCItr = 1;
            plot(xPlot, 1:ItrNo, GBestFit, 'r', 1:ItrNo, AvgFit, 'b');
            set(xPlot, 'XGrid', 'On',...
                'YGrid', 'On',...
                'Box', 'On',...
                'Units', 'Normalized',...
                'XLim', [1 MaxItr]);
        end
        
        % START PSO LOOP FROM HERE
        % ====================
        while success == 0
            %ITime = clock;
            
            if ~ishandle(figNum)
                return;
            end
            
            % DISPLAY PRESENT STATUS BELOW PLOTS
            set(ItrN, 'String', num2str(ItrNo));
            set(ItrR, 'String', num2str(MaxItr-ItrNo));
            
            sc = etime(clock, STime); TimeElapsed = clock - STime;
            dy = sc/(60*60*24); hr = (dy-fix(dy))*24; mn = (hr-fix(hr))*60; sc = (mn-fix(mn))*60;
            timestr = [num2str(fix(dy)), '/', num2str(fix(hr)), ':', num2str(fix(mn)), ':', num2str(fix(sc))];
            set(TimE, 'String', timestr);
            
            % PERSERVE PRESENT STATUS
            if ~strcmp(psoModel, 'GBest')
                save(matfile, 'nit', 'success', 'Swarm', 'GBest', 'PBest', 'ItrNo', 'TimeElapsed', 'PBestFit', 'GBestFit', 'AvgFit');
            else
                save(matfile, 'nit', 'success', 'Swarm', 'GBest', 'PBest', 'LBest', 'ItrNo', 'TimeElapsed', 'PBestFit', 'GBestFit', 'AvgFit');
            end
            
            % INITIAL, RANDOM & LIMITED VELOCITIES
            % ===========================
            Vel = MaxVel*rand(size(PBest));
            
            % INERTIA WEIGHTS
            % ============
            if strcmp(WtOpt, 'Fixed')
                Wt = StartWt;
            elseif strcmp(WtOpt, 'Variable')
                Wt = (EndWt - StartWt)*ItrNo/MaxItr;
            end
            
            % GBEST
            % ====================
            if strcmp(psoModel, 'GBest')
                GBestMat = repmat(GBest, PSize, 1);
                R1 = rand(size(Swarm)); R2 = rand(size(Swarm));
                Vel = Wt*Vel + C1*R1.*(PBest-Swarm) + C2*R2.*(GBestMat-Swarm);
                
                % LBEST AND RING TOPOLOGY
                % ====================
            elseif strcmp(psoModel, 'LBest') & strcmp(Topology, 'Ring')
                for n = 1:PSize
                    m = n-NSize:n+NSize;
                    mem = mod(m, PSize);
                    Group(n, :) = mem;
                end
                Group(find(Group==0)) = PSize;
                for n = 1:PSize
                    for m = 1:2*NSize+1
                        LSwarm(m, :, n) = PBest(Group(n, m), :);
                    end
                    LSwarmFit(n, :) = feval(ObjFun, LSwarm(:, :, n), TrgData);
                    [LBestFit(n, ItrNo) LBNo(n)] = min(LSwarmFit(n, :));
                    LBest(n, :) = LSwarm(LBNo(n), :, n);
                end
                
                R1 = rand(size(Swarm)); R3 = rand(size(Swarm));
                Vel = Wt*Vel + C1*R1.*(PBest-Swarm) + C3*R3.*(LBest-Swarm);
                
                % LBEST AND LINEAR TOPOLOGY
                % ====================
            elseif strcmp(psoModel, 'LBest') & strcmp(Topology, 'Linear')
                for n = 1:PSize
                    m = n-NSize:n+NSize;
                    mem = mod(m, PSize);
                    Grp(n, :) = mem;
                end
                Group = Grp(NSize+1:PSize-NSize, :);
                Group(find(Group==0)) = PSize;
                for n = 1:PSize-2*NSize
                    for m = 1:2*NSize+1
                        LSwarm(m, :, n) = PBest(Group(n, m), :);
                    end
                    LSwarmFit(n, :) = feval(ObjFun, LSwarm(:, :, n), TrgData);
                    [LBestFit(n, ItrNo) LBNo(n)] = min(LSwarmFit(n, :));
                    LBest(n, :) = LSwarm(LBNo(n), :, n);
                end
                ZeMat = zeros(NSize, size(Swarm, 2));
                LBestMat = [ZeMat; LBest; ZeMat];
                R1 = rand(size(Swarm)); R3 = rand(size(Swarm));
                Vel = Wt*Vel + C1*R1.*(PBest-Swarm) + C3*R3.*(LBestMat-Swarm);
                
                % HBEST AND RING TOPOLOGY
                % ====================
            elseif strcmp(psoModel, 'HBest') & strcmp(Topology, 'Ring')
                for n = 1:PSize
                    m = n-NSize:n+NSize;
                    mem = mod(m, PSize);
                    Group(n, :) = mem;
                end
                Group(find(Group==0)) = PSize;
                for n = 1:PSize
                    for m = 1:2*NSize+1
                        LSwarm(m, :, n) = PBest(Group(n, m), :);
                    end
                    LSwarmFit(n, :) = feval(ObjFun, LSwarm(:, :, n), TrgData);
                    [LBestFit(n, ItrNo) LBNo(n)] = min(LSwarmFit(n, :));
                    LBest(n, :) = LSwarm(LBNo(n), :, n);
                end
                
                GBestMat = repmat(GBest, PSize, 1);
                R1 = rand(size(Swarm)); R2 = rand(size(Swarm)); R3 = rand(size(Swarm));
                Vel = Wt*Vel + C1*R1.*(PBest-Swarm) + C2*R2.*(GBestMat-Swarm) + C3*R3.*(LBest-Swarm);
                
                % HBEST AND LINEAR TOPOLOGY
                % ====================
            elseif strcmp(psoModel, 'HBest') & strcmp(Topology, 'Linear')
                for n = 1:PSize
                    m = n-NSize:n+NSize;
                    mem = mod(m, PSize);
                    Grp(n, :) = mem;
                end
                Group = Grp(NSize+1:PSize-NSize, :);
                Group(find(Group==0)) = PSize;
                for n = 1:PSize-2*NSize
                    for m = 1:2*NSize+1
                        LSwarm(m, :, n) = PBest(Group(n, m), :);
                    end
                    LSwarmFit(n, :) = feval(ObjFun, LSwarm(:, :, n), TrgData);
                    [LBestFit(n, ItrNo) LBNo(n)] = min(LSwarmFit(n, :));
                    LBest(n, :) = LSwarm(LBNo(n), :, n);
                end
                ZeMat = zeros(NSize, size(Swarm, 2));
                LBestMat = [ZeMat; LBest; ZeMat];
                GBestMat = repmat(GBest, PSize, 1);
                R1 = rand(size(Swarm)); R2 = rand(size(Swarm)); R3 = rand(size(Swarm));
                Vel = Wt*Vel + C1*R1.*(PBest-Swarm) + C2*R2.*(GBestMat-Swarm) + C3*R3.*(LBestMat-Swarm);
                
                
                % WHEEL TOPOLOGY
                % ====================
            elseif (strcmp(psoModel, 'LBest')|strcmp(psoModel, 'HBest')) & strcmp(Topology, 'Wheel')
                'Wheel Topology - Pending'
                
            end
            
            % LIMIT VELOCITEIS WITH [-MaxVel +MaxVel]
            % =============================
            locat = Vel > MaxVel;
            Vel(find(locat)) = MaxVel;
            locat = Vel < -MaxVel;
            Vel(find(locat)) = -MaxVel;
            
            % CALCULATE NEW Swarm
            % ================
            Swarm = Swarm + Chi * Vel;
            
            % APPLY STRING CONSTRAINTS FOR VALID PARTICLES
            % ==================================
            Swarm = feval(validate, Swarm, Str, Chk);
            
            % CALCULATE Swarm FITNESS
            % ===================
            SwarmFit = feval(ObjFun, Swarm, TrgData);
            
            % UPDATE PBEST ON IMPROVEMENT
            % ======================
            FindParticle = SwarmFit < PBestFit;
            PBestFit(find(FindParticle)) = SwarmFit(find(FindParticle));
            PBest(find(FindParticle), :) = Swarm(find(FindParticle), :);
            
            ItrNo = ItrNo + 1;
            
            % RECORD AVERAGE FITNESS
            % ==================
            AvgFit(ItrNo) = mean(PBestFit);
            
            % UPDATE GBEST ON IMPROVEMENT
            % ======================
            [GBFitVal, GBNo] = min(PBestFit);
            if GBFitVal < GBestFit(ItrNo-1)
                GBest = PBest(GBNo, :);
                GBestFit(ItrNo) = GBFitVal;
            else
                GBestFit(ItrNo) = GBestFit(ItrNo-1);
            end
            
            if GBFitVal == GBestFit(ItrNo-1)
                NCItr = NCItr + 1;
            else
                NCItr = 1;
            end
            
            % FURNISH NIT PLOT FIGURE
            % ==================
            a = num2str(nit.Plot.Global);
            b = num2str(nit.Plot.Average);
            %1:ItrNo, GBestFit, LBestFit
            switch [a b] % PLOTS & LEGENDS REQUIRED
                case '01'
                    plot(xPlot, 1:ItrNo, AvgFit, 'b');
                    Lgd = legend(xPlot, 'Location', 'NorthEast', 'Average');
                case '10'
                    plot(xPlot, 1:ItrNo, GBestFit, 'r');
                    Lgd = legend(xPlot, 'Location', 'NorthEast', 'Global Best');
                case '11'
                    plot(xPlot, 1:ItrNo, GBestFit, 'r', 1:ItrNo, AvgFit, 'b');
                    Lgd = legend(xPlot, 'Location', 'NorthEast', 'Global Best', 'Average');
            end
            
            set(xPlot, 'XGrid', 'On', 'YGrid', 'On',...
                'Box', 'On', 'Units', 'Normalized',...
                'XLim', [1 MaxItr]);
            
            Xl = xlabel(xPlot, 'Iterations', 'FontName', 'Verdana',...
                'FontSize', 10);
            Yl = ylabel(xPlot, 'Fitness', 'FontName', 'Verdana',...
                'FontSize', 10);
            Ttl = title(xPlot, 'PROGRESS GRAPHS', 'FontName', 'Verdana',...
                'FontSize', 10, 'FontWeight', 'Bold');
            set(GBstF, 'String', num2str(GBestFit(ItrNo)));
            set(AvF, 'String', num2str(AvgFit(ItrNo)));
            
            tpi = (TimeElapsed(4)*60*60+TimeElapsed(5)*60+TimeElapsed(6))/ItrNo;
            tr = tpi*(MaxItr-ItrNo);
            dy = tr/(60*60*24); hr = (dy-fix(dy))*24; mn = (hr-fix(hr))*60; tr = (mn-fix(mn))*60;
            timestrg = [num2str(fix(dy)), '/', num2str(fix(hr)), ':', num2str(fix(mn)), ':', num2str(fix(tr))];
            set(TimR, 'String', timestrg);
            
            % CRITERIA TO END LOOP
            % ================
            if NCItr == NoChange
                success = 1; 'NO CHANGE'
                if ~strcmp(psoModel, 'GBest')
                    save(matfile, 'nit', 'success', 'Swarm', 'GBest', 'PBest', 'ItrNo', 'TimeElapsed', 'PBestFit', 'GBestFit', 'AvgFit');
                else
                    save(matfile, 'nit', 'success', 'Swarm', 'GBest', 'PBest', 'LBest', 'ItrNo', 'TimeElapsed', 'PBestFit', 'GBestFit', 'AvgFit');
                end
                xlswrite(nit.String.File, GBest', nit.String.Sheet, ['E2:E' num2str(size(Swarm, 2)+1)]);
            elseif feval(ObjFun, GBest, TrgData) == Goal
                success = 1; 'GOAL ACHIEVED'
                if ~strcmp(psoModel, 'GBest')
                    save(matfile, 'nit', 'success', 'Swarm', 'GBest', 'PBest', 'ItrNo', 'TimeElapsed', 'PBestFit', 'GBestFit', 'AvgFit');
                else
                    save(matfile, 'nit', 'success', 'Swarm', 'GBest', 'PBest', 'LBest', 'ItrNo', 'TimeElapsed', 'PBestFit', 'GBestFit', 'AvgFit');
                end
                xlswrite(nit.String.File, GBest', nit.String.Sheet, ['E2:E' num2str(size(Swarm, 2)+1)]);
            elseif ItrNo == MaxItr
                success = 1; 'MAX ITERATION'
                if ~strcmp(psoModel, 'GBest')
                    save(matfile, 'nit', 'success', 'Swarm', 'GBest', 'PBest', 'ItrNo', 'TimeElapsed', 'PBestFit', 'GBestFit', 'AvgFit');
                else
                    save(matfile, 'nit', 'success', 'Swarm', 'GBest', 'PBest', 'LBest', 'ItrNo', 'TimeElapsed', 'PBestFit', 'GBestFit', 'AvgFit');
                end
                xlswrite(nit.String.File, GBest', nit.String.Sheet, ['E2:E' num2str(size(Swarm, 2)+1)]);
            end
            pause(0.0001)
        end
        RESULT = 1;
        
        % ====================
        % BBO LOOP STARTS HERE
    elseif strcmp(nit.Type, 'BBO')
        
        matfile = nit.Name;
        
        % Habitat String Validation Function
        validate = nit.String.VFunction;
        
        % Migation Module Parameters
        numElite = nit.Migration.Elite;
        MxImmigrate = nit.Migration.ImmRate;
        ImmCurve = nit.Migration.ImmCurve;
        MxEmigration = nit.Migration.EmiRate;
        EmiCurve = nit.Migration.EmiCurve;
        
        % BBO Strategy Parameter Module
        PSize = nit.Parameter.Habitats;
        MigProb = nit.Parameter.Migration;
        MutProb = nit.Parameter.Mutation;
        MutOperator = nit.Parameter.MutOperator;
        fitnessFunction = nit.Objective.Function;
        
        % SWARM INITIALIZATION
        Str = xlsread(nit.String.File, nit.String.Sheet, nit.String.Range);
        Chk = xlsread(nit.Checks.File, nit.Checks.Sheet, nit.Checks.Range);
        iSwarm = genrandpop(PSize, Str, Chk);
        iSwarm = feval(validate, iSwarm, Str, Chk);
        
        TrgData = xlsread(nit.Objective.File, nit.Objective.Sheet, nit.Objective.Range);
        
        % BBO Run Termination Criteria
        NoChange = nit.Terminate.NoChange;       % No Change Fitness Iterations
        Goal = nit.Terminate.Goal;              % Minimum Acceptable Error
        MaxItr = nit.Terminate.MaxIterations;       % Maximum Number of iteration to be run
        
        % INITIAL PARAMETERS
        % ==============
        if strcmp(udRs, 'restart')
            iSwarm = genrandpop(PSize, Str, Chk);
            iSwarm = feval(validate, iSwarm, Str, Chk);
            ItrNo = 1; success = 0; NCItr = 1;
            Swarm = iSwarm;
            
            HSI = feval(fitnessFunction, Swarm, TrgData);
            srtHSInSwm = sortrows([HSI Swarm]);
            srtHSI = srtHSInSwm(:, 1);
            srtSwm = srtHSInSwm(:, 2:size(Swarm,2)+1);
            
            AvgHSI(ItrNo) = mean(srtHSI);
            [Val Num] = min(srtHSI);     % GlobalBestHSI
            GBHSI(ItrNo) = Val;
            GBHbt(ItrNo, :) = srtSwm(Num, :);     % GlobalBestHabitat
            BestHSI(ItrNo) = min(srtHSI);
            BestHbt(ItrNo, :) = srtSwm(Num, :);
            cla(xPlot);
        elseif strcmp(udRe, 'resume')
            load(matfile); STime = clock-TimeElapsed;
            success = 0; NCItr = 1;
            plot(xPlot, 1:ItrNo, BestHSI, 'r', 1:ItrNo, AvgHSI, 'b');
            set(xPlot, 'XGrid', 'On',...
                'YGrid', 'On',...
                'Box', 'On',...
                'Units', 'Normalized',...
                'XLim', [1 MaxItr]);
        end
        
        % START BBO LOOP FROM HERE
        % ====================
        while success == 0
            
            if ~ishandle(figNum)
                return;
            end
            
            % DISPLAY PRESENT STATUS BELOW PLOTS
            set(ItrN, 'String', num2str(ItrNo));
            set(ItrR, 'String', num2str(MaxItr-ItrNo));
            
            sc = etime(clock, STime); TimeElapsed = clock - STime;
            dy = sc/(60*60*24); hr = (dy-fix(dy))*24; mn = (hr-fix(hr))*60; sc = (mn-fix(mn))*60;
            timestr = [num2str(fix(dy)), '/', num2str(fix(hr)), ':', num2str(fix(mn)), ':', num2str(fix(sc))];
            set(TimE, 'String', timestr);
            
            % MIGRATION PROCESS
            EliteHbt = srtSwm(1, :);
            EliteHSI = feval(fitnessFunction, EliteHbt, TrgData);
            
            mgSwarm = migrateSwarm(srtSwm, ImmCurve, MxImmigrate, EmiCurve, MxEmigration);
            mgSwarm = feval(validate, mgSwarm, Str, Chk);
            HSI = -feval(fitnessFunction, mgSwarm, TrgData);

            % PRESERVE & EMBED ONE ELITE SOLUTION
            if (min(HSI) > EliteHSI)
                [mxVal num] = max(HSI);
                mgSwarm(num, :) = EliteHbt;
                HSI(num, :) = EliteHSI;
            else
                [mnVal num] = min(HSI);
                EliteHSI = mnVal;
                EliteHbt = mgSwarm(num, :);
            end
            
            srtHSInSwm = sortrows([HSI mgSwarm]);
            srtHSI = -srtHSInSwm(:, 1);
            srtSwm = srtHSInSwm(:, 2:size(mgSwarm,2)+1);
            
            [Val Num] = min(srtHSI);     % GlobalBestHSI
            GBHSI(ItrNo) = Val;
            GBHbt(ItrNo, :) = srtSwm(Num, :);     % GlobalBestHabitat
            
            % MUTATION PROCESS
            mtSwarm = mutateSwarm(srtSwm, MutProb, MutOperator, ImmCurve, MxImmigrate, EmiCurve, MxEmigration);
            mtSwarm = feval(validate, mtSwarm, Str, Chk);
            HSI = -feval(fitnessFunction, mtSwarm, TrgData);
            % PRESERVE & EMBED ONE ELITE SOLUTION
            if (min(HSI) > EliteHSI)
                [mxVal num] = max(HSI);
                mtSwarm(num, :) = EliteHbt;
                HSI(num, :) = EliteHSI;
            else
                [mnVal num] = min(HSI);
                EliteHSI = mnVal;
                EliteHbt = mtSwarm(num, :);
            end
            
            srtHSInSwm = sortrows([HSI mtSwarm]);
            srtHSI = -srtHSInSwm(:, 1);
            srtSwm = srtHSInSwm(:, 2:size(mtSwarm,2)+1);
            
            [Val Num] = min(srtHSI);     % GlobalBestHSI
            GBHSI(ItrNo) = Val;
            GBHbt(ItrNo, :) = srtSwm(Num, :);     % GlobalBestHabitat

            AvgHSI(ItrNo) = mean(srtHSI);

            if ItrNo > 1
                if GBHSI(ItrNo) <= min(GBHSI)
                    BestHbt(ItrNo, :) = GBHbt(ItrNo, :);
                    BestHSI(ItrNo) = GBHSI(ItrNo);
                else
                    mnHSI = find(GBHSI==min(GBHSI));
                    BestHbt(ItrNo, :) = GBHbt(mnHSI(length(mnHSI)), :);
                    BestHSI(ItrNo) = GBHSI(mnHSI(length(mnHSI)));
                end
                if GBHSI(ItrNo) == GBHSI(ItrNo-1)
                    NCItr = NCItr + 1;
                else
                    NCItr = 1;
                end
            end

            % FURNISH NIT PLOT FIGURE
            % ==================
            a = num2str(nit.Plot.Global);
            b = num2str(nit.Plot.Average);
            
            switch [a b] % PLOTS & LEGENDS REQUIRED
                case '01'
                    plot(xPlot, 1:ItrNo, AvgHSI, 'b');
                    Lgd = legend(xPlot, 'Location', 'NorthEast', 'Average');
                case '10'
                    plot(xPlot, 1:ItrNo, BestHSI, 'r');
                    Lgd = legend(xPlot, 'Location', 'NorthEast', 'Global Best');
                case '11'
                    plot(xPlot, 1:ItrNo, BestHSI, 'r', 1:ItrNo, AvgHSI, 'b');
                    Lgd = legend(xPlot, 'Location', 'NorthEast', 'Global Best', 'Average');
            end
            
            set(xPlot, 'XGrid', 'On', 'YGrid', 'On',...
                'Box', 'On', 'Units', 'Normalized',...
                'XLim', [1 MaxItr]);
            
            Xl = xlabel(xPlot, 'Iterations', 'FontName', 'Verdana',...
                'FontSize', 10);
            Yl = ylabel(xPlot, 'Fitness', 'FontName', 'Verdana',...
                'FontSize', 10);
            Ttl = title(xPlot, 'PROGRESS GRAPHS', 'FontName', 'Verdana',...
                'FontSize', 10, 'FontWeight', 'Bold');
            set(GBstF, 'String', num2str(BestHSI(ItrNo)));
            set(AvF, 'String', num2str(AvgHSI(ItrNo)));
            
            tpi = (TimeElapsed(4)*60*60+TimeElapsed(5)*60+TimeElapsed(6))/ItrNo;
            tr = tpi*(MaxItr-ItrNo);
            dy = tr/(60*60*24); hr = (dy-fix(dy))*24; mn = (hr-fix(hr))*60; tr = (mn-fix(mn))*60;
            timestrg = [num2str(fix(dy)), '/', num2str(fix(hr)), ':', num2str(fix(mn)), ':', num2str(fix(tr))];
            set(TimR, 'String', timestrg);

            save(matfile, 'nit', 'success', 'srtSwm', 'GBHbt', 'BestHSI', 'BestHbt', 'ItrNo', 'TimeElapsed', 'GBHSI', 'AvgHSI');
            % CRITERIA TO END LOOP
            % ================
            if NCItr == NoChange
                success = 1; 'NO CHANGE'
                xlswrite(nit.String.File, BestHbt(ItrNo,:)', nit.String.Sheet, ['E2:E' num2str(size(Swarm, 2)+1)]);
            elseif feval(fitnessFunction, GBHbt, TrgData) == Goal
                success = 1; 'GOAL ACHIEVED'
                xlswrite(nit.String.File, BestHbt(ItrNo,:)', nit.String.Sheet, ['E2:E' num2str(size(Swarm, 2)+1)]);
            elseif ItrNo == MaxItr
                success = 1; 'MAX ITERATION'
                xlswrite(nit.String.File, BestHbt(ItrNo,:)', nit.String.Sheet, ['E2:E' num2str(size(Swarm, 2)+1)]);
            end
            ItrNo = ItrNo + 1;            
            pause(0.0001)
        end
        RESULT = 1;
    elseif strcmp(nit.Type, 'GA')
        % GA LOOP
        RESULT = 0;
        
    elseif strcmp(nit.Type, 'ACO')
        % ACO LOOP
        result = 0;
        
    end
    
elseif strcmp(argu, '#resume')
    figNum = watchon;
    Hdl = gcbo;
    set(Hdl, 'UserData', 'resume');
    watchoff;
    runnit #evolve
elseif strcmp(argu, '#restart')
    figNum = watchon;
    Hdl = gcbo;
    set(Hdl, 'UserData', 'restart');
    watchoff;
    runnit #evolve
end
