%{
x = [0:.1:5];
fs1 = zmf(x, [1 2]);
fs2 = zmf(x, [2 3]);
up = umf(fs1, fs2, x);
plot(x, fs1, x, fs2,x, up);
%  up is Upper Membership Function of x
%}
function up = umf(fs1, fs2, x)
L = length(x);
up = [];
% plot(x, fs1, x, fs2)
p1 = max(find(fs1==max(fs1)));
p2 = max(find(fs2==max(fs2)));
for i = 1:L
    if fs1(i)>=fs2(i)
        up(i) = fs1(i);
    end
    if fs1(i)<fs2(i)
        up(i) = fs2(i);
    end
end

if p1<=p2
    for p = p1:1:p2
        up(p)=1;
    end
else
    for p = p2:1:p1
        up(p)=1;
    end
end
