%     NIT     NATURE INSPIRED TOOLBOX

% ======================================================
%   PROGRAM AIM :
%         TO WRITE NIT FILE FROM SYSTEM STRUCTURE
% ======================================================
%   USAGE :
%         1. out = wrnit(nit, fileName)
%         2. out = wrnit(nit)
%         3. out = wrnit
% ==============================================
%   SATVIR SINGH SIDHU, ARUN KHOSLA, JASBIR SINGH SAINI
%   JULY 2009
%   COPYRIGHT RESERVED
% ==============================================

function out = wrnit(nit, fileName)
if nargin < 1
    out = error('No NIT Structure is supplied');
elseif nargin < 2
    switch upper(nit.Type)
        case 'PSO'
            [fileName, pathName] = uiputfile( ...
                {'*.PSO','Particle Swarm Optimization (*.PSO)'; ...
                '*.*',  'All Files (*.*)'},...
                'Save File Name');
            extn = fileName(find(fileName == '.')+1:length(fileName));
            fileName = fileName(1:find(fileName == '.')-1);
            fid = fopen([pathName fileName '.' extn], 'w');
            if fid==-1
                out = error('Unable to write System Struture to File');
            end
            
            fprintf(fid, '[NI SYSTEM]\n\n');
            fprintf(fid, 'nit.Name = ''%s''\n', fileName);
            fprintf(fid, 'nit.Type = ''%s''\n\n', nit.Type);
            
            fprintf(fid, '[PARTICLE STRING ENCODING]\n');
            fprintf(fid, 'nit.String.File = ''%s''\n', nit.String.File);
            fprintf(fid, 'nit.String.Sheet = ''%s''\n', nit.String.Sheet);
            fprintf(fid, 'nit.String.Range = ''%s''\n\n', nit.String.Range);
            
            fprintf(fid, '[STRING ENCODING CHECKS]\n');
            fprintf(fid, 'nit.Checks.File = ''%s''\n', nit.Checks.File);
            fprintf(fid, 'nit.Checks.Sheet = ''%s''\n', nit.Checks.Sheet);
            fprintf(fid, 'nit.Checks.Range = ''%s''\n\n', nit.Checks.Range);
            
            fprintf(fid, '[SWARM DESCRIPTION]\n');
            fprintf(fid, 'nit.Swarm.PSize = %s\n', num2str(nit.Swarm.PSize));
            fprintf(fid, 'nit.Swarm.VFunction = ''%s''\n', nit.Swarm.VFunction);
            fprintf(fid, 'nit.Swarm.Model = ''%s''\n', nit.Swarm.Model);
            fprintf(fid, 'nit.Swarm.NSize = %1.0f\n', nit.Swarm.NSize);
            fprintf(fid, 'nit.Swarm.Topology = ''%s''\n\n', nit.Swarm.Topology);
            
            fprintf(fid, '[OBJECTIVE DESCRIPTION]\n');
            fprintf(fid, 'nit.Objective.File = ''%s''\n', nit.Objective.File);
            fprintf(fid, 'nit.Objective.Sheet = ''%s''\n', nit.Objective.Sheet);
            fprintf(fid, 'nit.Objective.Range = ''%s''\n', nit.Objective.Range);
            fprintf(fid, 'nit.Objective.Function = ''%s''\n\n', nit.Objective.Function);
            
            fprintf(fid, '[STRATEGIC PARAMETERS]\n');
            fprintf(fid, 'nit.Parameter.C1 = %s\n', num2str(nit.Parameter.C1));
            fprintf(fid, 'nit.Parameter.C2 = %s\n', num2str(nit.Parameter.C2));
            fprintf(fid, 'nit.Parameter.C3 = %s\n', num2str(nit.Parameter.C3));
            fprintf(fid, 'nit.Parameter.MaxVelocity = %s\n', num2str(nit.Parameter.MaxVelocity));
            fprintf(fid, 'nit.Parameter.Chi = %s\n', num2str(nit.Parameter.Chi));
            fprintf(fid, 'nit.Parameter.WeightOption = ''%s''\n', nit.Parameter.WeightOption);
            fprintf(fid, 'nit.Parameter.StartWeight = %s\n', num2str(nit.Parameter.StartWeight));
            fprintf(fid, 'nit.Parameter.EndWeight = %s\n\n', num2str(nit.Parameter.EndWeight));
            
            fprintf(fid, '[TERMINATION CRITERIA]\n');
            fprintf(fid, 'nit.Terminate.NoChange = %s\n', num2str(nit.Terminate.NoChange));
            fprintf(fid, 'nit.Terminate.Goal = %s\n', num2str(nit.Terminate.Goal));
            fprintf(fid, 'nit.Terminate.MaxIterations = %s\n\n', num2str(nit.Terminate.MaxIterations));
            
            fprintf(fid, '[PLOT OPTIONS]\n');
            fprintf(fid, 'nit.Plot.Global = %s\n', num2str(nit.Plot.Global));
            fprintf(fid, 'nit.Plot.Average = %s\n', num2str(nit.Plot.Average));
            
        case 'GA'
            [fileName, pathName] = uiputfile( ...
                {'*.GA','Genetic Algorithms (*.GA)'; ...
                '*.*',  'All Files (*.*)'},...
                'Save File Name');
            dsip('Pending Module - GA')
        case 'ACO'
            [fileName, pathName] = uiputfile( ...
                {'*.ACO','Ant Colony Optimization (*.ACO)'; ...
                '*.*',  'All Files (*.*)'},...
                'Save File Name');
            dsip('Pending Module - ACO')
        case 'BBO'
            [fileName, pathName] = uiputfile( ...
                {'*.BBO','Biogeoraphical Based Optimization (*.BBO)'; ...
                '*.*',  'All Files (*.*)'},...
                'Save File Name');
            extn = fileName(find(fileName == '.')+1:length(fileName));
            fileName = fileName(1:find(fileName == '.')-1);
            fid = fopen([pathName fileName '.' extn], 'w');
            if fid==-1
                out = error('Unable to write System Struture to File')
            end
            
            fprintf(fid, '[NI SYSTEM]\n\n');
            fprintf(fid, 'nit.Name = ''%s''\n', fileName);
            fprintf(fid, 'nit.Type = ''%s''\n\n', extn);
            
            fprintf(fid, '[HABITAT STRING ENCODING]\n');
            fprintf(fid, 'nit.String.File = ''%s''\n', nit.String.File);
            fprintf(fid, 'nit.String.Sheet = ''%s''\n', nit.String.Sheet);
            fprintf(fid, 'nit.String.Range = ''%s''\n', nit.String.Range);
            fprintf(fid, 'nit.String.VFunction = ''%s''\n\n', nit.String.VFunction);
            
            fprintf(fid, '[STRING ENCODING CHECKS]\n');
            fprintf(fid, 'nit.Checks.File = ''%s''\n', nit.Checks.File);
            fprintf(fid, 'nit.Checks.Sheet = ''%s''\n', nit.Checks.Sheet);
            fprintf(fid, 'nit.Checks.Range = ''%s''\n\n', nit.Checks.Range);
            
            fprintf(fid, '[MIGRATION CURVES]\n');
            fprintf(fid, 'nit.Migration.Elite = %s\n', num2str(nit.Migration.Elite));
            fprintf(fid, 'nit.Migration.ImmRate = %s\n', num2str(nit.Migration.ImmRate));
            fprintf(fid, 'nit.Migration.ImmCurve = ''%s''\n', deblank(nit.Migration.ImmCurve));
            fprintf(fid, 'nit.Migration.EmiRate = %s\n', num2str(nit.Migration.EmiRate));
            fprintf(fid, 'nit.Migration.EmiCurve = ''%s''\n\n', deblank(nit.Migration.EmiCurve));

            fprintf(fid, '[OBJECTIVE DESCRIPTION]\n');
            fprintf(fid, 'nit.Objective.File = ''%s''\n', nit.Objective.File);
            fprintf(fid, 'nit.Objective.Sheet = ''%s''\n', nit.Objective.Sheet);
            fprintf(fid, 'nit.Objective.Range = ''%s''\n', nit.Objective.Range);
            fprintf(fid, 'nit.Objective.Function = ''%s''\n\n', nit.Objective.Function);

            fprintf(fid, '[STRATEGIC PARAMETERS]\n');
            fprintf(fid, 'nit.Parameter.Habitats = %s\n', num2str(nit.Parameter.Habitats));
            fprintf(fid, 'nit.Parameter.MigOperator = ''%s''\n', deblank(nit.Parameter.MigOperator));
            fprintf(fid, 'nit.Parameter.Migration = %s\n', num2str(nit.Parameter.Migration));
            fprintf(fid, 'nit.Parameter.MutOperator = ''%s''\n', deblank(nit.Parameter.MutOperator));
            fprintf(fid, 'nit.Parameter.Mutation = %s\n', num2str(nit.Parameter.Mutation));
            fprintf(fid, 'nit.Parameter.Pool = ''%s''\n', deblank(nit.Parameter.Pool));
            fprintf(fid, 'nit.Parameter.Refusal = ''%s''\n', deblank(nit.Parameter.Refusal));
            fprintf(fid, 'nit.Parameter.Threshold = %s\n\n', num2str(nit.Parameter.Threshold));

            fprintf(fid, '[TERMINATION CRITERIA]\n');
            fprintf(fid, 'nit.Terminate.NoChange = %s\n', num2str(nit.Terminate.NoChange));
            fprintf(fid, 'nit.Terminate.Goal = %s\n', num2str(nit.Terminate.Goal));
            fprintf(fid, 'nit.Terminate.MaxIterations = %s\n\n', num2str(nit.Terminate.MaxIterations));
            
            fprintf(fid, '[PLOT OPTIONS]\n');
            fprintf(fid, 'nit.Plot.Global = %s\n', num2str(nit.Plot.Global));
            fprintf(fid, 'nit.Plot.Average = %s\n', num2str(nit.Plot.Average));
        otherwise
            error('Improper file Extension specified')
    end
end
% if isequal(fileName,0)
%    disp('User selected Cancel');
% end

nit.Name = fileName;
out = nit;
fclose(fid);